/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.jmeter.assertions.gui.XMLConfPanel;
import org.apache.jmeter.extractor.XPathExtractor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.TidyException;
import org.apache.jmeter.util.XPathUtil;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.ViewResultsFullVisualizer;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class RenderAsXPath
implements ResultRenderer,
ActionListener {
    private static final Logger log = LoggerFactory.getLogger(RenderAsXPath.class);
    private static final String XPATH_TESTER_COMMAND = "xpath_tester";
    private JPanel xmlWithXPathPane;
    private JTextArea xmlDataField;
    private JLabeledTextField xpathExpressionField;
    private JTextArea xpathResultField;
    private JTabbedPane rightSide;
    private SampleResult sampleResult = null;
    private JScrollPane xmlDataPane;
    private final JCheckBox getFragment = new JCheckBox(JMeterUtils.getResString((String)"xpath_tester_fragment"));
    private final XMLConfPanel xmlConfPanel = new XMLConfPanel();

    @Override
    public void clearData() {
        this.xmlDataField.setText("");
        this.xpathResultField.setText("");
    }

    @Override
    public void init() {
        this.xmlWithXPathPane = this.createXpathExtractorPanel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (this.sampleResult != null && XPATH_TESTER_COMMAND.equals(command)) {
            String response = this.xmlDataField.getText();
            XPathExtractor extractor = new XPathExtractor();
            this.xmlConfPanel.modifyTestElement(extractor);
            extractor.setFragment(this.getFragment.isSelected());
            this.executeAndShowXPathTester(response, extractor);
        }
    }

    private void executeAndShowXPathTester(String textToParse, XPathExtractor extractor) {
        if (textToParse != null && textToParse.length() > 0 && this.xpathExpressionField.getText().length() > 0) {
            this.xpathResultField.setText(this.process(textToParse, extractor));
            this.xpathResultField.setCaretPosition(0);
        }
    }

    private String process(String textToParse, XPathExtractor extractor) {
        try {
            Document doc = this.parseResponse(textToParse, extractor);
            ArrayList matchStrings = new ArrayList();
            XPathUtil.putValuesForXPathInList((Document)doc, (String)this.xpathExpressionField.getText(), matchStrings, (boolean)extractor.getFragment());
            StringBuilder builder = new StringBuilder();
            int nbFound = matchStrings.size();
            builder.append("Match count: ").append(nbFound).append("\n");
            for (int i = 0; i < nbFound; ++i) {
                builder.append("Match[").append(i + 1).append("]=").append((String)matchStrings.get(i)).append("\n");
            }
            return builder.toString();
        }
        catch (Exception e) {
            return "Exception:" + ExceptionUtils.getStackTrace((Throwable)e);
        }
    }

    private Document parseResponse(String unicodeData, XPathExtractor extractor) throws IOException, ParserConfigurationException, SAXException, TidyException {
        byte[] utf8data = unicodeData.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream in = new ByteArrayInputStream(utf8data);
        boolean isXML = JOrphanUtils.isXML((byte[])utf8data);
        return XPathUtil.makeDocument((InputStream)in, (boolean)false, (boolean)false, (boolean)extractor.useNameSpace(), (boolean)extractor.isTolerant(), (boolean)extractor.isQuiet(), (boolean)extractor.showWarnings(), (boolean)extractor.reportErrors(), (boolean)isXML, (boolean)extractor.isDownloadDTDs());
    }

    @Override
    public void renderResult(SampleResult sampleResult) {
        String response = ViewResultsFullVisualizer.getResponseAsString(sampleResult);
        try {
            this.xmlDataField.setText(response == null ? "" : response);
            this.xmlDataField.setCaretPosition(0);
        }
        catch (Exception e) {
            log.error("Exception converting to XML: {}, message: {}", new Object[]{response, e.getMessage(), e});
            this.xmlDataField.setText("Exception converting to XML:" + response + ", message:" + e.getMessage());
            this.xmlDataField.setCaretPosition(0);
        }
    }

    @Override
    public String toString() {
        return JMeterUtils.getResString((String)XPATH_TESTER_COMMAND);
    }

    @Override
    public void setupTabPane() {
        if (this.rightSide.indexOfTab(JMeterUtils.getResString((String)"xpath_tester_title")) < 0) {
            this.rightSide.addTab(JMeterUtils.getResString((String)"xpath_tester_title"), this.xmlWithXPathPane);
        }
        this.clearData();
    }

    private JPanel createXpathExtractorPanel() {
        this.xmlDataField = new JTextArea();
        this.xmlDataField.setEditable(false);
        this.xmlDataField.setLineWrap(true);
        this.xmlDataField.setWrapStyleWord(true);
        this.xmlDataPane = GuiUtils.makeScrollPane((Component)this.xmlDataField);
        this.xmlDataPane.setPreferredSize(new Dimension(0, 200));
        JPanel pane = new JPanel(new BorderLayout(0, 5));
        JSplitPane mainSplit = new JSplitPane(0, this.xmlDataPane, this.createXpathExtractorTasksPanel());
        mainSplit.setDividerLocation(0.6);
        mainSplit.setOneTouchExpandable(true);
        pane.add((Component)mainSplit, "Center");
        return pane;
    }

    private JPanel createXpathExtractorTasksPanel() {
        Box xpathActionPanel = Box.createVerticalBox();
        Box selectorAndButton = Box.createHorizontalBox();
        EmptyBorder margin = new EmptyBorder(5, 5, 0, 5);
        xpathActionPanel.setBorder(margin);
        this.xpathExpressionField = new JLabeledTextField(JMeterUtils.getResString((String)"xpath_tester_field"));
        JButton xpathTester = new JButton(JMeterUtils.getResString((String)"xpath_tester_button_test"));
        xpathTester.setActionCommand(XPATH_TESTER_COMMAND);
        xpathTester.addActionListener(this);
        selectorAndButton.add((Component)this.xpathExpressionField);
        selectorAndButton.add(xpathTester);
        xpathActionPanel.add(selectorAndButton);
        xpathActionPanel.add(this.xmlConfPanel);
        xpathActionPanel.add(this.getFragment);
        this.xpathResultField = new JTextArea();
        this.xpathResultField.setEditable(false);
        this.xpathResultField.setLineWrap(true);
        this.xpathResultField.setWrapStyleWord(true);
        JPanel xpathTasksPanel = new JPanel(new BorderLayout(0, 5));
        xpathTasksPanel.add((Component)xpathActionPanel, "North");
        xpathTasksPanel.add((Component)GuiUtils.makeScrollPane((Component)this.xpathResultField), "Center");
        return xpathTasksPanel;
    }

    @Override
    public synchronized void setRightSide(JTabbedPane side) {
        this.rightSide = side;
    }

    @Override
    public synchronized void setSamplerResult(Object userObject) {
        if (userObject instanceof SampleResult) {
            this.sampleResult = (SampleResult)userObject;
        }
    }

    @Override
    public void setLastSelectedTab(int index) {
    }

    @Override
    public void renderImage(SampleResult sampleResult) {
        this.clearData();
        this.xmlDataField.setText(JMeterUtils.getResString((String)"xpath_tester_no_text"));
    }

    @Override
    public void setBackgroundColor(Color backGround) {
    }
}

