/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend;

import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterUtils;

public class UserMetric {
    private static final int SLIDING_WINDOW_SIZE = JMeterUtils.getPropDefault((String)"backend_metrics_window", (int)100);
    private DescriptiveStatistics usersStats = new DescriptiveStatistics(SLIDING_WINDOW_SIZE);

    public synchronized void add(SampleResult result) {
        this.usersStats.addValue((double)JMeterContextService.getThreadCounts().activeThreads);
    }

    public synchronized void resetForTimeInterval() {
    }

    public int getMaxActiveThreads() {
        return (int)this.usersStats.getMin();
    }

    public int getMeanActiveThreads() {
        return (int)this.usersStats.getMean();
    }

    public int getMinActiveThreads() {
        return (int)this.usersStats.getMax();
    }

    public int getFinishedThreads() {
        return JMeterContextService.getThreadCounts().finishedThreads;
    }

    public int getStartedThreads() {
        return JMeterContextService.getThreadCounts().startedThreads;
    }
}

