/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.Component;
import java.awt.GridLayout;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.XPathUtil;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.SamplerResultTab;
import org.apache.jmeter.visualizers.XMLDefaultMutableTreeNode;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;
import org.xml.sax.SAXException;

public class RenderAsXML
extends SamplerResultTab
implements ResultRenderer {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final byte[] XML_PFX = new byte[]{60, 63, 120, 109, 108, 32};

    public RenderAsXML() {
        this.activateSearchExtension = false;
    }

    public void renderResult(SampleResult sampleResult) {
        this.showRenderXMLResponse(sampleResult);
    }

    private void showRenderXMLResponse(SampleResult res) {
        this.results.setContentType("text/xml");
        this.results.setCaretPosition(0);
        byte[] source = res.getResponseData();
        ByteArrayInputStream baIS = new ByteArrayInputStream(source);
        for (int i = 0; i < source.length - XML_PFX.length; ++i) {
            if (!JOrphanUtils.startsWith((byte[])source, (byte[])XML_PFX, (int)i)) continue;
            baIS.skip(i);
            break;
        }
        Document document = null;
        StringWriter sw = new StringWriter();
        Tidy tidy = XPathUtil.makeTidyParser((boolean)true, (boolean)true, (boolean)true, (StringWriter)sw);
        document = tidy.parseDOM((InputStream)baIS, null);
        document.normalize();
        if (tidy.getParseErrors() > 0) {
            RenderAsXML.showErrorMessageDialog(sw.toString(), "Tidy: " + tidy.getParseErrors() + " errors, " + tidy.getParseWarnings() + " warnings", 2);
        }
        DOMTreePanel domTreePanel = new DOMTreePanel(document);
        this.resultsScrollPane.setViewportView(domTreePanel);
    }

    public void clearData() {
        super.clearData();
        this.resultsScrollPane.setViewportView(null);
    }

    private static void showErrorMessageDialog(String message, String title, int messageType) {
        JOptionPane.showMessageDialog(null, message, title, messageType);
    }

    public String toString() {
        return JMeterUtils.getResString((String)"view_results_render_xml");
    }

    private static class DOMTreePanel
    extends JPanel {
        private static final long serialVersionUID = 6871690021183779153L;
        private JTree domJTree;

        public DOMTreePanel(Document document) {
            super(new GridLayout(1, 0));
            try {
                Node firstElement = this.getFirstElement(document);
                XMLDefaultMutableTreeNode top = new XMLDefaultMutableTreeNode(firstElement);
                this.domJTree = new JTree(top);
                this.domJTree.getSelectionModel().setSelectionMode(1);
                this.domJTree.setShowsRootHandles(true);
                JScrollPane domJScrollPane = new JScrollPane(this.domJTree);
                this.domJTree.setAutoscrolls(true);
                this.add(domJScrollPane);
                ToolTipManager.sharedInstance().registerComponent(this.domJTree);
                this.domJTree.setCellRenderer(new DomTreeRenderer());
            }
            catch (SAXException e) {
                log.warn("Error trying to parse document", (Throwable)e);
            }
        }

        private Node getFirstElement(Node parent) {
            NodeList childNodes = parent.getChildNodes();
            Node toReturn = parent;
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode;
                toReturn = childNode = childNodes.item(i);
                if (childNode.getNodeType() == 1) break;
            }
            return toReturn;
        }

        private static class DomTreeRenderer
        extends DefaultTreeCellRenderer {
            private static final long serialVersionUID = 240210061375790195L;

            private DomTreeRenderer() {
            }

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean phasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, phasFocus);
                DefaultMutableTreeNode valueTreeNode = (DefaultMutableTreeNode)value;
                this.setToolTipText(this.getHTML(valueTreeNode.toString(), "<br>", 100));
                return this;
            }

            private String getHTML(String str, String separator, int maxChar) {
                StringBuilder strBuf = new StringBuilder("<html><body bgcolor=\"yellow\"><b>");
                char[] chars = str.toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    if (i % maxChar == 0 && i != 0) {
                        strBuf.append(separator);
                    }
                    strBuf.append(this.encode(chars[i]));
                }
                strBuf.append("</b></body></html>");
                return strBuf.toString();
            }

            private String encode(char c) {
                String toReturn = String.valueOf(c);
                switch (c) {
                    case '<': {
                        toReturn = "&lt;";
                        break;
                    }
                    case '>': {
                        toReturn = "&gt;";
                        break;
                    }
                    case '\'': {
                        toReturn = "&apos;";
                        break;
                    }
                    case '\"': {
                        toReturn = "&quot;";
                        break;
                    }
                }
                return toReturn;
            }
        }
    }
}

