/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.sampler.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.sampler.TestAction;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class TestActionGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = 240L;
    private JComboBox targetBox;
    private JRadioButton pauseButton;
    private JRadioButton stopButton;
    private JRadioButton stopNowButton;
    private JRadioButton restartNextLoopButton;
    private JTextField durationField;
    private int target = 0;
    private int action = 1;
    private String durationString = "";
    private final String targetLabel = JMeterUtils.getResString((String)"test_action_target");
    private final String threadTarget = JMeterUtils.getResString((String)"test_action_target_thread");
    private final String testTarget = JMeterUtils.getResString((String)"test_action_target_test");
    private final String actionLabel = JMeterUtils.getResString((String)"test_action_action");
    private final String pauseAction = JMeterUtils.getResString((String)"test_action_pause");
    private final String stopAction = JMeterUtils.getResString((String)"test_action_stop");
    private final String stopNowAction = JMeterUtils.getResString((String)"test_action_stop_now");
    private final String restartNextLoopAction = JMeterUtils.getResString((String)"test_action_restart_next_loop");
    private final String durationLabel = JMeterUtils.getResString((String)"test_action_duration");

    public TestActionGui() {
        this.init();
    }

    public String getLabelResource() {
        return "test_action_title";
    }

    public void configure(TestElement element) {
        super.configure(element);
        TestAction ta = (TestAction)element;
        this.target = ta.getTarget();
        if (this.target == 0) {
            this.targetBox.setSelectedItem(this.threadTarget);
        } else {
            this.targetBox.setSelectedItem(this.testTarget);
        }
        this.action = ta.getAction();
        if (this.action == 1) {
            this.pauseButton.setSelected(true);
        } else if (this.action == 2) {
            this.stopNowButton.setSelected(true);
        } else if (this.action == 0) {
            this.stopButton.setSelected(true);
        } else {
            this.restartNextLoopButton.setSelected(true);
        }
        this.durationString = ta.getDurationAsString();
        this.durationField.setText(this.durationString);
    }

    public TestElement createTestElement() {
        TestAction ta = new TestAction();
        this.modifyTestElement((TestElement)ta);
        return ta;
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        TestAction ta = (TestAction)element;
        ta.setAction(this.action);
        ta.setTarget(this.target);
        ta.setDuration(this.durationString);
    }

    public void clearGui() {
        super.clearGui();
        this.targetBox.setSelectedIndex(0);
        this.durationString = "";
        this.durationField.setText("");
        this.pauseButton.setSelected(true);
        this.action = 1;
        this.target = 0;
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 3, 1));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        HorizontalPanel targetPanel = new HorizontalPanel();
        targetPanel.add((Component)new JLabel(this.targetLabel));
        DefaultComboBoxModel<String> targetModel = new DefaultComboBoxModel<String>();
        targetModel.addElement(this.threadTarget);
        targetModel.addElement(this.testTarget);
        this.targetBox = new JComboBox(targetModel);
        this.targetBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((String)TestActionGui.this.targetBox.getSelectedItem()).equals(TestActionGui.this.threadTarget)) {
                    TestActionGui.this.target = 0;
                } else {
                    TestActionGui.this.target = 2;
                }
            }
        });
        targetPanel.add((Component)this.targetBox);
        this.add((Component)targetPanel);
        HorizontalPanel actionPanel = new HorizontalPanel();
        ButtonGroup actionButtons = new ButtonGroup();
        this.pauseButton = new JRadioButton(this.pauseAction, true);
        this.pauseButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (TestActionGui.this.pauseButton.isSelected()) {
                    TestActionGui.this.action = 1;
                    TestActionGui.this.durationField.setEnabled(true);
                    TestActionGui.this.targetBox.setEnabled(true);
                }
            }
        });
        this.stopButton = new JRadioButton(this.stopAction, false);
        this.stopButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (TestActionGui.this.stopButton.isSelected()) {
                    TestActionGui.this.action = 0;
                    TestActionGui.this.durationField.setEnabled(false);
                    TestActionGui.this.targetBox.setEnabled(true);
                }
            }
        });
        this.stopNowButton = new JRadioButton(this.stopNowAction, false);
        this.stopNowButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (TestActionGui.this.stopNowButton.isSelected()) {
                    TestActionGui.this.action = 2;
                    TestActionGui.this.durationField.setEnabled(false);
                    TestActionGui.this.targetBox.setEnabled(true);
                }
            }
        });
        this.restartNextLoopButton = new JRadioButton(this.restartNextLoopAction, false);
        this.restartNextLoopButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (TestActionGui.this.restartNextLoopButton.isSelected()) {
                    TestActionGui.this.action = 3;
                    TestActionGui.this.durationField.setEnabled(false);
                    TestActionGui.this.targetBox.setSelectedIndex(0);
                    TestActionGui.this.targetBox.setEnabled(false);
                }
            }
        });
        actionButtons.add(this.pauseButton);
        actionButtons.add(this.stopButton);
        actionButtons.add(this.stopNowButton);
        actionButtons.add(this.restartNextLoopButton);
        actionPanel.add((Component)new JLabel(this.actionLabel));
        actionPanel.add((Component)this.pauseButton);
        actionPanel.add((Component)this.stopButton);
        actionPanel.add((Component)this.stopNowButton);
        actionPanel.add((Component)this.restartNextLoopButton);
        this.add((Component)actionPanel);
        HorizontalPanel durationPanel = new HorizontalPanel();
        this.durationField = new JTextField(15);
        this.durationField.setText("");
        this.durationField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                TestActionGui.this.durationString = TestActionGui.this.durationField.getText();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        durationPanel.add((Component)new JLabel(this.durationLabel));
        durationPanel.add((Component)this.durationField);
        this.add((Component)durationPanel);
    }
}

