/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.TidyException;
import org.apache.jmeter.util.XPathUtil;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XPathAssertion
extends AbstractTestElement
implements Serializable,
Assertion {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    private static final String XPATH_KEY = "XPath.xpath";
    private static final String WHITESPACE_KEY = "XPath.whitespace";
    private static final String VALIDATE_KEY = "XPath.validate";
    private static final String TOLERANT_KEY = "XPath.tolerant";
    private static final String NEGATE_KEY = "XPath.negate";
    private static final String NAMESPACE_KEY = "XPath.namespace";
    private static final String QUIET_KEY = "XPath.quiet";
    private static final String REPORT_ERRORS_KEY = "XPath.report_errors";
    private static final String SHOW_WARNINGS_KEY = "XPath.show_warnings";
    private static final String DOWNLOAD_DTDS = "XPath.download_dtds";
    public static final String DEFAULT_XPATH = "/";

    public AssertionResult getResult(SampleResult response) {
        AssertionResult result = new AssertionResult(this.getName());
        byte[] responseData = response.getResponseData();
        if (responseData.length == 0) {
            return result.setResultForNull();
        }
        result.setFailure(false);
        result.setFailureMessage("");
        if (log.isDebugEnabled()) {
            log.debug("Validation is set to " + this.isValidating());
            log.debug("Whitespace is set to " + this.isWhitespace());
            log.debug("Tolerant is set to " + this.isTolerant());
        }
        Document doc = null;
        boolean isXML = JOrphanUtils.isXML((byte[])responseData);
        try {
            doc = XPathUtil.makeDocument((InputStream)new ByteArrayInputStream(responseData), (boolean)this.isValidating(), (boolean)this.isWhitespace(), (boolean)this.isNamespace(), (boolean)this.isTolerant(), (boolean)this.isQuiet(), (boolean)this.showWarnings(), (boolean)this.reportErrors(), (boolean)isXML, (boolean)this.isDownloadDTDs());
        }
        catch (SAXException e) {
            log.debug("Caught sax exception: " + e);
            result.setError(true);
            result.setFailureMessage("SAXException: " + e.getMessage());
            return result;
        }
        catch (IOException e) {
            log.warn("Cannot parse result content", (Throwable)e);
            result.setError(true);
            result.setFailureMessage("IOException: " + e.getMessage());
            return result;
        }
        catch (ParserConfigurationException e) {
            log.warn("Cannot parse result content", (Throwable)e);
            result.setError(true);
            result.setFailureMessage("ParserConfigurationException: " + e.getMessage());
            return result;
        }
        catch (TidyException e) {
            result.setError(true);
            result.setFailureMessage(e.getMessage());
            return result;
        }
        if (doc == null || doc.getDocumentElement() == null) {
            result.setError(true);
            result.setFailureMessage("Document is null, probably not parsable");
            return result;
        }
        XPathUtil.computeAssertionResult((AssertionResult)result, (Document)doc, (String)this.getXPathString(), (boolean)this.isNegated());
        return result;
    }

    public String getXPathString() {
        return this.getPropertyAsString(XPATH_KEY, DEFAULT_XPATH);
    }

    public void setXPathString(String xpath) {
        this.setProperty((JMeterProperty)new StringProperty(XPATH_KEY, xpath));
    }

    public void setWhitespace(boolean whitespace) {
        this.setProperty((JMeterProperty)new BooleanProperty(WHITESPACE_KEY, whitespace));
    }

    public void setValidating(boolean validate) {
        this.setProperty((JMeterProperty)new BooleanProperty(VALIDATE_KEY, validate));
    }

    public void setNamespace(boolean namespace) {
        this.setProperty((JMeterProperty)new BooleanProperty(NAMESPACE_KEY, namespace));
    }

    public void setTolerant(boolean tolerant) {
        this.setProperty((JMeterProperty)new BooleanProperty(TOLERANT_KEY, tolerant));
    }

    public void setNegated(boolean negate) {
        this.setProperty((JMeterProperty)new BooleanProperty(NEGATE_KEY, negate));
    }

    public boolean isWhitespace() {
        return this.getPropertyAsBoolean(WHITESPACE_KEY, false);
    }

    public boolean isValidating() {
        return this.getPropertyAsBoolean(VALIDATE_KEY, false);
    }

    public boolean isNamespace() {
        return this.getPropertyAsBoolean(NAMESPACE_KEY, false);
    }

    public boolean isTolerant() {
        return this.getPropertyAsBoolean(TOLERANT_KEY, false);
    }

    public boolean isNegated() {
        return this.getPropertyAsBoolean(NEGATE_KEY, false);
    }

    public void setReportErrors(boolean val) {
        this.setProperty(REPORT_ERRORS_KEY, val, false);
    }

    public boolean reportErrors() {
        return this.getPropertyAsBoolean(REPORT_ERRORS_KEY, false);
    }

    public void setShowWarnings(boolean val) {
        this.setProperty(SHOW_WARNINGS_KEY, val, false);
    }

    public boolean showWarnings() {
        return this.getPropertyAsBoolean(SHOW_WARNINGS_KEY, false);
    }

    public void setQuiet(boolean val) {
        this.setProperty(QUIET_KEY, val, true);
    }

    public boolean isQuiet() {
        return this.getPropertyAsBoolean(QUIET_KEY, true);
    }

    public void setDownloadDTDs(boolean val) {
        this.setProperty(DOWNLOAD_DTDS, val, false);
    }

    public boolean isDownloadDTDs() {
        return this.getPropertyAsBoolean(DOWNLOAD_DTDS, false);
    }
}

