/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.jmeter.DynamicClassLoader;

public final class NewDriver {
    private static final String CLASSPATH_SEPARATOR;
    private static final String OS_NAME;
    private static final String OS_NAME_LC;
    private static final String JAVA_CLASS_PATH = "java.class.path";
    private static final DynamicClassLoader loader;
    private static final String jmDir;

    private NewDriver() {
    }

    private static File[] listJars(File dir) {
        if (dir.isDirectory()) {
            return dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File f, String name) {
                    if (name.endsWith(".jar")) {
                        File jar = new File(f, name);
                        return jar.isFile() && jar.canRead();
                    }
                    return false;
                }
            });
        }
        return new File[0];
    }

    public static void addURL(String path) {
        File[] jars;
        File furl = new File(path);
        try {
            loader.addURL(furl.toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        for (File jar : jars = NewDriver.listJars(furl)) {
            try {
                loader.addURL(jar.toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addURL(URL url) {
        loader.addURL(url);
    }

    public static void addPath(String path) throws MalformedURLException {
        File[] jars;
        File file = new File(path);
        if (file.isDirectory() && !path.endsWith("/")) {
            file = new File(path + "/");
        }
        loader.addURL(file.toURI().toURL());
        StringBuilder sb = new StringBuilder(System.getProperty(JAVA_CLASS_PATH));
        sb.append(CLASSPATH_SEPARATOR);
        sb.append(path);
        for (File jar : jars = NewDriver.listJars(file)) {
            try {
                loader.addURL(jar.toURI().toURL());
                sb.append(CLASSPATH_SEPARATOR);
                sb.append(jar.getPath());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        System.setProperty(JAVA_CLASS_PATH, sb.toString());
    }

    public static String getJMeterDir() {
        return jmDir;
    }

    public static void main(String[] args) {
        Thread.currentThread().setContextClassLoader(loader);
        if (System.getProperty("log4j.configuration") == null) {
            File conf = new File(jmDir, "bin" + File.separator + "log4j.conf");
            System.setProperty("log4j.configuration", "file:" + conf);
        }
        try {
            Class<?> initialClass = args != null && args.length > 0 && args[0].equals("report") ? loader.loadClass("org.apache.jmeter.JMeterReport") : loader.loadClass("org.apache.jmeter.JMeter");
            Object instance = initialClass.newInstance();
            Method startup = initialClass.getMethod("start", new String[0].getClass());
            startup.invoke(instance, new Object[]{args});
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("JMeter home directory was detected as: " + jmDir);
        }
    }

    static {
        File[] libDirs;
        CLASSPATH_SEPARATOR = System.getProperty("path.separator");
        OS_NAME = System.getProperty("os.name");
        OS_NAME_LC = OS_NAME.toLowerCase(Locale.ENGLISH);
        final LinkedList<URL> jars = new LinkedList<URL>();
        String initial_classpath = System.getProperty(JAVA_CLASS_PATH);
        String tmpDir = null;
        StringTokenizer tok = new StringTokenizer(initial_classpath, File.pathSeparator);
        if (tok.countTokens() == 1 || tok.countTokens() == 2 && OS_NAME_LC.startsWith("mac os x")) {
            File jar = new File(tok.nextToken());
            try {
                tmpDir = jar.getCanonicalFile().getParentFile().getParent();
            }
            catch (IOException e) {}
        } else {
            tmpDir = System.getProperty("jmeter.home", "");
            if (tmpDir.length() == 0) {
                File userDir = new File(System.getProperty("user.dir"));
                tmpDir = userDir.getAbsoluteFile().getParent();
            }
        }
        jmDir = tmpDir;
        boolean usesUNC = OS_NAME_LC.startsWith("windows");
        StringBuilder classpath = new StringBuilder();
        for (File libDir : libDirs = new File[]{new File(jmDir + File.separator + "lib"), new File(jmDir + File.separator + "lib" + File.separator + "ext"), new File(jmDir + File.separator + "lib" + File.separator + "junit")}) {
            Object[] libJars = libDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            if (libJars == null) {
                new Throwable("Could not access " + libDir).printStackTrace();
                continue;
            }
            Arrays.sort(libJars);
            for (Object libJar : libJars) {
                try {
                    String s = ((File)libJar).getPath();
                    if (usesUNC) {
                        if (s.startsWith("\\\\") && !s.startsWith("\\\\\\")) {
                            s = "\\\\" + s;
                        } else if (s.startsWith("//") && !s.startsWith("///")) {
                            s = "//" + s;
                        }
                    }
                    jars.add(new File(s).toURI().toURL());
                    classpath.append(CLASSPATH_SEPARATOR);
                    classpath.append(s);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        System.setProperty(JAVA_CLASS_PATH, initial_classpath + classpath.toString());
        loader = AccessController.doPrivileged(new PrivilegedAction<DynamicClassLoader>(){

            @Override
            public DynamicClassLoader run() {
                return new DynamicClassLoader(jars.toArray(new URL[jars.size()]));
            }
        });
    }
}

