/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.handlers;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.apache.jena.arq.querybuilder.handlers.AggregationHandler;
import org.apache.jena.arq.querybuilder.handlers.Handler;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.lang.arq.javacc.ARQParser;
import org.apache.jena.sparql.lang.arq.javacc.ParseException;
import org.apache.jena.sparql.lang.arq.javacc.TokenMgrError;

public class SelectHandler
implements Handler {
    private final Query query;
    private final AggregationHandler aggHandler;

    public SelectHandler(AggregationHandler aggHandler) {
        this.query = aggHandler.getQuery();
        this.aggHandler = aggHandler;
        this.setDistinct(this.query.isDistinct());
        this.setReduced(this.query.isReduced());
    }

    public void setDistinct(boolean state) {
        this.query.setDistinct(state);
        if (state) {
            this.query.setReduced(false);
        }
    }

    public void setReduced(boolean state) {
        this.query.setReduced(state);
        if (state) {
            this.query.setDistinct(false);
        }
    }

    public void addVar(Var var) {
        if (var == null) {
            this.query.setQueryResultStar(true);
        } else {
            this.query.setQueryResultStar(false);
            this.query.addResultVar((Node)var);
        }
    }

    public void addVar(String expression, Var var) {
        this.addVar(this.parseExpr(expression), var);
    }

    private Expr parseExpr(String s) throws QueryParseException {
        try {
            ARQParser parser = new ARQParser((Reader)new StringReader("SELECT " + s));
            parser.setQuery(new Query());
            parser.getQuery().setPrefixMapping(this.query.getPrefixMapping());
            parser.SelectClause();
            Query q = parser.getQuery();
            VarExprList vel = q.getProject();
            return (Expr)vel.getExprs().values().iterator().next();
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginLine);
        }
        catch (TokenMgrError tErr) {
            throw new QueryParseException(tErr.getMessage(), -1, -1);
        }
        catch (Error err) {
            String tmp = err.getMessage();
            if (tmp == null) {
                throw new QueryParseException((Throwable)err, -1, -1);
            }
            throw new QueryParseException(tmp, -1, -1);
        }
    }

    public void addVar(Expr expr, Var var) {
        if (expr == null) {
            throw new IllegalArgumentException("expr may not be null");
        }
        if (var == null) {
            throw new IllegalArgumentException("var may not be null");
        }
        this.query.setQueryResultStar(false);
        this.query.addResultVar((Node)var, expr);
        this.aggHandler.add(expr, var);
    }

    public List<Var> getVars() {
        return this.query.getProjectVars();
    }

    public VarExprList getProject() {
        return this.query.getProject();
    }

    public void addAll(SelectHandler selectHandler) {
        this.setReduced(selectHandler.query.isReduced());
        this.setDistinct(selectHandler.query.isDistinct());
        this.query.setQueryResultStar(selectHandler.query.isQueryResultStar());
        VarExprList shProjectVars = selectHandler.query.getProject();
        VarExprList qProjectVars = this.query.getProject();
        for (Var var : shProjectVars.getVars()) {
            if (qProjectVars.contains(var)) continue;
            qProjectVars.add(var, shProjectVars.getExpr(var));
        }
        this.aggHandler.addAll(selectHandler.aggHandler);
    }

    @Override
    public void setVars(Map<Var, Node> values) {
    }

    @Override
    public void build() {
        if (this.query.getProject().getVars().isEmpty()) {
            this.query.setQueryResultStar(true);
        }
        this.aggHandler.build();
        this.query.getProjectVars();
    }
}

