/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.Converters;
import org.apache.jena.arq.querybuilder.Order;
import org.apache.jena.arq.querybuilder.clauses.ConstructClause;
import org.apache.jena.arq.querybuilder.clauses.DatasetClause;
import org.apache.jena.arq.querybuilder.clauses.SolutionModifierClause;
import org.apache.jena.arq.querybuilder.clauses.WhereClause;
import org.apache.jena.arq.querybuilder.handlers.ConstructHandler;
import org.apache.jena.arq.querybuilder.handlers.DatasetHandler;
import org.apache.jena.arq.querybuilder.handlers.HandlerBlock;
import org.apache.jena.arq.querybuilder.handlers.SolutionModifierHandler;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;

public class ConstructBuilder
extends AbstractQueryBuilder<ConstructBuilder>
implements DatasetClause<ConstructBuilder>,
WhereClause<ConstructBuilder>,
SolutionModifierClause<ConstructBuilder>,
ConstructClause<ConstructBuilder> {
    private final HandlerBlock handlerBlock;

    public ConstructBuilder() {
        this.query.setQueryConstructType();
        this.handlerBlock = new HandlerBlock(this.query);
    }

    @Override
    public DatasetHandler getDatasetHandler() {
        return this.handlerBlock.getDatasetHandler();
    }

    @Override
    public ConstructHandler getConstructHandler() {
        return this.handlerBlock.getConstructHandler();
    }

    @Override
    public SolutionModifierHandler getSolutionModifierHandler() {
        return this.handlerBlock.getModifierHandler();
    }

    @Override
    public HandlerBlock getHandlerBlock() {
        return this.handlerBlock;
    }

    public ConstructBuilder clone() {
        ConstructBuilder qb = new ConstructBuilder();
        qb.handlerBlock.addAll(this.handlerBlock);
        return qb;
    }

    @Override
    public ConstructBuilder fromNamed(Object graphName) {
        this.getDatasetHandler().fromNamed(graphName);
        return this;
    }

    @Override
    public ConstructBuilder from(Object graphName) {
        this.getDatasetHandler().from(graphName);
        return this;
    }

    @Override
    public ConstructBuilder addOrderBy(Expr orderBy) {
        this.getSolutionModifierHandler().addOrderBy(orderBy);
        return this;
    }

    @Override
    public ConstructBuilder addOrderBy(Object orderBy) {
        this.getSolutionModifierHandler().addOrderBy(Converters.makeVar(orderBy));
        return this;
    }

    @Override
    public ConstructBuilder addOrderBy(SortCondition orderBy) {
        this.getSolutionModifierHandler().addOrderBy(orderBy);
        return this;
    }

    @Override
    public ConstructBuilder addOrderBy(Expr orderBy, Order order) {
        this.getSolutionModifierHandler().addOrderBy(orderBy, order);
        return this;
    }

    @Override
    public ConstructBuilder addOrderBy(Object orderBy, Order order) {
        this.getSolutionModifierHandler().addOrderBy(Converters.makeVar(orderBy), order);
        return this;
    }

    @Override
    public ConstructBuilder addGroupBy(Object groupBy) {
        this.getSolutionModifierHandler().addGroupBy(Converters.makeVar(groupBy));
        return this;
    }

    @Override
    public ConstructBuilder addGroupBy(Expr groupBy) {
        this.getSolutionModifierHandler().addGroupBy(groupBy);
        return this;
    }

    @Override
    public ConstructBuilder addGroupBy(Object var, Expr expr) {
        this.getSolutionModifierHandler().addGroupBy(Converters.makeVar(var), expr);
        return this;
    }

    @Override
    public ConstructBuilder addGroupBy(Object var, String expr) {
        this.getSolutionModifierHandler().addGroupBy(Converters.makeVar(var), this.makeExpr(expr));
        return this;
    }

    @Override
    public ConstructBuilder addHaving(String having) {
        this.getSolutionModifierHandler().addHaving(having);
        return this;
    }

    @Override
    public ConstructBuilder addHaving(Expr expression) {
        this.getSolutionModifierHandler().addHaving(expression);
        return this;
    }

    @Override
    public ConstructBuilder addHaving(Object var) {
        this.getSolutionModifierHandler().addHaving(Converters.makeVar(var));
        return this;
    }

    @Override
    public ConstructBuilder setLimit(int limit) {
        this.getSolutionModifierHandler().setLimit(limit);
        return this;
    }

    @Override
    public ConstructBuilder setOffset(int offset) {
        this.getSolutionModifierHandler().setOffset(offset);
        return this;
    }

    @Override
    public ConstructBuilder addWhere(TriplePath t) {
        this.getWhereHandler().addWhere(t);
        return this;
    }

    @Override
    public ConstructBuilder addWhere(Collection<TriplePath> collection) {
        this.getWhereHandler().addWhere(collection);
        return this;
    }

    @Override
    public ConstructBuilder addWhere(Triple t) {
        this.getWhereHandler().addWhere(new TriplePath(t));
        return this;
    }

    @Override
    public ConstructBuilder addWhere(FrontsTriple t) {
        this.getWhereHandler().addWhere(new TriplePath(t.asTriple()));
        return this;
    }

    @Override
    public ConstructBuilder addWhere(Object s, Object p, Object o) {
        this.getWhereHandler().addWhere(this.makeTriplePaths(s, p, o));
        return this;
    }

    @Override
    public ConstructBuilder addWhereValueVar(Object var) {
        this.getWhereHandler().addValueVar(this.getPrologHandler().getPrefixes(), var);
        return this;
    }

    @Override
    public ConstructBuilder addWhereValueVar(Object var, Object ... values) {
        this.getWhereHandler().addValueVar(this.getPrologHandler().getPrefixes(), var, values);
        return this;
    }

    @Override
    public <K extends Collection<?>> ConstructBuilder addWhereValueVars(Map<?, K> dataTable) {
        this.getWhereHandler().addValueVars(this.getPrologHandler().getPrefixes(), dataTable);
        return this;
    }

    @Override
    public ConstructBuilder addWhereValueRow(Object ... values) {
        this.getWhereHandler().addValueRow(this.getPrologHandler().getPrefixes(), values);
        return this;
    }

    @Override
    public ConstructBuilder addWhereValueRow(Collection<?> values) {
        this.getWhereHandler().addValueRow(this.getPrologHandler().getPrefixes(), values);
        return this;
    }

    @Override
    public List<Var> getWhereValuesVars() {
        return this.getWhereHandler().getValuesVars();
    }

    @Override
    public Map<Var, List<Node>> getWhereValuesMap() {
        return this.getWhereHandler().getValuesMap();
    }

    @Override
    public ConstructBuilder clearWhereValues() {
        this.getWhereHandler().clearValues();
        return this;
    }

    @Override
    public ConstructBuilder addOptional(TriplePath t) {
        this.getWhereHandler().addOptional(Arrays.asList(t));
        return this;
    }

    @Override
    public ConstructBuilder addOptional(Collection<TriplePath> collection) {
        this.getWhereHandler().addOptional(collection);
        return this;
    }

    @Override
    public ConstructBuilder addOptional(Triple t) {
        return this.addOptional(new TriplePath(t));
    }

    @Override
    public ConstructBuilder addOptional(AbstractQueryBuilder<?> t) {
        this.getWhereHandler().addOptional(t.getWhereHandler());
        return this;
    }

    @Override
    public ConstructBuilder addOptional(FrontsTriple t) {
        return this.addOptional(new TriplePath(t.asTriple()));
    }

    @Override
    public ConstructBuilder addOptional(Object s, Object p, Object o) {
        this.getWhereHandler().addOptional(this.makeTriplePaths(s, p, o));
        return this;
    }

    @Override
    public ConstructBuilder addFilter(Expr expr) {
        this.getWhereHandler().addFilter(expr);
        return this;
    }

    @Override
    public ConstructBuilder addFilter(String s) {
        this.getWhereHandler().addFilter(s);
        return this;
    }

    @Override
    public ConstructBuilder addSubQuery(AbstractQueryBuilder<?> subQuery) {
        this.getWhereHandler().addSubQuery(subQuery);
        return this;
    }

    @Override
    public ConstructBuilder addUnion(AbstractQueryBuilder<?> subQuery) {
        this.getWhereHandler().addUnion(subQuery);
        return this;
    }

    @Override
    public ConstructBuilder addGraph(Object graph, AbstractQueryBuilder<?> subQuery) {
        this.getPrologHandler().addAll(subQuery.getPrologHandler());
        this.getWhereHandler().addGraph(this.makeNode(graph), subQuery.getWhereHandler());
        return this;
    }

    @Override
    public ConstructBuilder addGraph(Object graph, FrontsTriple triple) {
        return this.addGraph(graph, new TriplePath(triple.asTriple()));
    }

    @Override
    public ConstructBuilder addGraph(Object graph, Object subject, Object predicate, Object object) {
        this.getWhereHandler().addGraph(this.makeNode(graph), this.makeTriplePaths(subject, predicate, object));
        return this;
    }

    @Override
    public ConstructBuilder addGraph(Object graph, Triple triple) {
        return this.addGraph(graph, new TriplePath(triple));
    }

    @Override
    public ConstructBuilder addGraph(Object graph, TriplePath triplePath) {
        this.getWhereHandler().addGraph(this.makeNode(graph), Arrays.asList(triplePath));
        return this;
    }

    @Override
    public ConstructBuilder addGraph(Object graph, Collection<TriplePath> collection) {
        this.getWhereHandler().addGraph(this.makeNode(graph), collection);
        return this;
    }

    @Override
    public ConstructBuilder addBind(Expr expression, Object var) {
        this.getWhereHandler().addBind(expression, Converters.makeVar(var));
        return this;
    }

    @Override
    public ConstructBuilder addBind(String expression, Object var) {
        this.getWhereHandler().addBind(expression, Converters.makeVar(var));
        return this;
    }

    @Override
    public ConstructBuilder addConstruct(Triple t) {
        this.getConstructHandler().addConstruct(t);
        return this;
    }

    @Override
    public ConstructBuilder addConstruct(FrontsTriple t) {
        return this.addConstruct(t.asTriple());
    }

    @Override
    public ConstructBuilder addConstruct(Object s, Object p, Object o) {
        return this.addConstruct(Triple.create((Node)this.makeNode(s), (Node)this.makeNode(p), (Node)this.makeNode(o)));
    }

    @Override
    public ConstructBuilder addMinus(AbstractQueryBuilder<?> t) {
        this.getWhereHandler().addMinus(t);
        return this;
    }
}

