/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.handlers;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.jena.arq.querybuilder.handlers.Handler;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Node_Literal;
import org.apache.jena.graph.Node_URI;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;

public class DatasetHandler
implements Handler {
    private final Query query;

    public DatasetHandler(Query query) {
        this.query = query;
    }

    public void addAll(DatasetHandler datasetHandler) {
        this.from(datasetHandler.query.getGraphURIs());
        this.fromNamed(datasetHandler.query.getNamedGraphURIs());
    }

    String asGraphName(Object graphName) {
        if (graphName instanceof String) {
            return (String)graphName;
        }
        if (graphName instanceof FrontsNode) {
            return this.asGraphName(((FrontsNode)graphName).asNode());
        }
        if (graphName instanceof Node_URI) {
            return ((Node_URI)graphName).getURI();
        }
        if (graphName instanceof Node_Literal) {
            return this.asGraphName(((Node_Literal)graphName).getLiteralValue());
        }
        return graphName.toString();
    }

    public void fromNamed(Object graphName) {
        this.processGraphName(arg_0 -> ((Query)this.query).addNamedGraphURI(arg_0), graphName);
    }

    private void processGraphName(Consumer<String> process, Object graphName) {
        if (graphName instanceof Iterable) {
            for (Object o : (Iterable)graphName) {
                process.accept(this.asGraphName(o));
            }
        } else {
            process.accept(this.asGraphName(graphName));
        }
    }

    public void from(Object graphName) {
        this.processGraphName(arg_0 -> ((Query)this.query).addGraphURI(arg_0), graphName);
    }

    private void setVars(Map<Var, Node> values, List<String> lst) {
        if (values.isEmpty() || lst == null || lst.isEmpty()) {
            return;
        }
        for (int i = 0; i < lst.size(); ++i) {
            String s = lst.get(i);
            Node n = null;
            if (!s.startsWith("?")) continue;
            Var v = Var.alloc((String)s.substring(1));
            n = values.get(v);
            String x = s;
            if (n != null) {
                x = n.isURI() ? n.getURI() : (n.isLiteral() ? n.getLiteralLexicalForm() : n.toString());
            }
            lst.set(i, x);
        }
    }

    @Override
    public void setVars(Map<Var, Node> values) {
        this.setVars(values, this.query.getNamedGraphURIs());
        this.setVars(values, this.query.getGraphURIs());
    }

    @Override
    public void build() {
    }
}

