/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.repositories;

import java.net.URI;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.ontapi.GraphRepository;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.shared.JenaException;

public class DocumentGraphRepository
implements GraphRepository {
    private final Supplier<Graph> factory;
    private final Map<String, Source> idToSource = new HashMap<String, Source>();
    private final Map<Source, Graph> sourceToGraph = new HashMap<Source, Graph>();

    public DocumentGraphRepository() {
        this(GraphMemFactory::createDefaultGraph);
    }

    public DocumentGraphRepository(Supplier<Graph> factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    public static String checkLocation(String uriOrFile) {
        Objects.requireNonNull(uriOrFile, "Null fileNameOrURI");
        RuntimeException ex = new RuntimeException("Wrong URI: <" + uriOrFile + ">");
        String file = null;
        if (uriOrFile.startsWith("file:")) {
            file = uriOrFile.replace("file:", "/");
        } else if (uriOrFile.startsWith("/")) {
            file = uriOrFile;
        }
        try {
            if (file != null) {
                Paths.get(file, new String[0]);
            }
            return uriOrFile;
        }
        catch (Exception e) {
            ex.addSuppressed(e);
            try {
                new URI(uriOrFile);
                return uriOrFile;
            }
            catch (Exception e2) {
                ex.addSuppressed(e2);
                throw ex;
            }
        }
    }

    private static Source parseLocation(String uriOrFile) {
        return new Source(DocumentGraphRepository.checkLocation(uriOrFile), RDFLanguages.resourceNameToLang((String)uriOrFile, (Lang)Lang.RDFXML));
    }

    private static Graph read(Source source, Graph target) {
        RDFParser.create().source(source.location).lang(source.lang).parse(target);
        return target;
    }

    public DocumentGraphRepository addMapping(String id, String uriOrFile) {
        Objects.requireNonNull(id, "Null Graph Id");
        Source source = DocumentGraphRepository.parseLocation(Objects.requireNonNull(uriOrFile, "location (file or uri) is required"));
        this.idToSource.put(id, source);
        this.idToSource.put(uriOrFile, source);
        return this;
    }

    @Override
    public Graph get(String id) {
        try {
            Source source = this.idToSource.computeIfAbsent(Objects.requireNonNull(id, "Null Graph Id"), DocumentGraphRepository::parseLocation);
            return this.sourceToGraph.computeIfAbsent(source, it -> DocumentGraphRepository.read(it, this.factory.get()));
        }
        catch (JenaException e) {
            this.idToSource.remove(id);
            throw e;
        }
    }

    @Override
    public Stream<String> ids() {
        return this.getIds().stream();
    }

    @Override
    public Graph put(String id, Graph graph) {
        Objects.requireNonNull(id, "Null Graph Id");
        Objects.requireNonNull(graph, "Null Graph");
        Source source = this.idToSource.computeIfAbsent(id, it -> new Source((String)it, RDFLanguages.resourceNameToLang((String)id, (Lang)Lang.RDFXML)));
        return this.sourceToGraph.put(source, graph);
    }

    @Override
    public Graph remove(String id) {
        Source source = this.idToSource.remove(Objects.requireNonNull(id, "Null Graph Id"));
        if (source == null) {
            return null;
        }
        this.idToSource.entrySet().stream().toList().stream().filter(it -> source.equals(it.getValue())).forEach(it -> this.idToSource.remove(it.getKey()));
        return this.sourceToGraph.remove(source);
    }

    @Override
    public void clear() {
        this.sourceToGraph.clear();
        this.idToSource.clear();
    }

    @Override
    public long count() {
        return this.getIds().size();
    }

    @Override
    public Stream<Graph> graphs() {
        return this.sourceToGraph.values().stream();
    }

    @Override
    public boolean contains(String id) {
        return this.idToSource.containsKey(Objects.requireNonNull(id, "Null Graph Id"));
    }

    protected Set<String> getIds() {
        return this.idToSource.keySet();
    }

    private record Source(String location, Lang lang) {
    }
}

