/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.compute.function;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.profitbricks.ProfitBricksApi;
import org.jclouds.profitbricks.domain.DataCenter;
import org.jclouds.profitbricks.domain.Nic;
import org.jclouds.profitbricks.domain.OsType;
import org.jclouds.profitbricks.domain.Server;
import org.jclouds.profitbricks.domain.Storage;
import org.jclouds.util.InetAddresses2;

public class ServerToNodeMetadata
implements Function<Server, NodeMetadata> {
    private final Function<Storage, Volume> fnVolume;
    private final Supplier<Set<? extends Location>> locations;
    private final Function<List<Nic>, List<String>> fnCollectIps;
    private final ProfitBricksApi api;
    private final GroupNamingConvention groupNamingConvention;

    @Inject
    ServerToNodeMetadata(Function<Storage, Volume> fnVolume, @Memoized Supplier<Set<? extends Location>> locations, ProfitBricksApi api, GroupNamingConvention.Factory groupNamingConvention) {
        this.fnVolume = fnVolume;
        this.locations = locations;
        this.api = api;
        this.groupNamingConvention = groupNamingConvention.createWithoutPrefix();
        this.fnCollectIps = new Function<List<Nic>, List<String>>(){

            public List<String> apply(List<Nic> in) {
                ArrayList ips = Lists.newArrayListWithExpectedSize((int)in.size());
                for (Nic nic : in) {
                    ips.addAll(nic.ips());
                }
                return ips;
            }
        };
    }

    public NodeMetadata apply(Server server) {
        Preconditions.checkNotNull((Object)server, (Object)"Null server");
        DataCenter dataCenter = this.api.dataCenterApi().getDataCenter(server.dataCenter().id());
        Location location = (Location)Iterables.find((Iterable)((Iterable)this.locations.get()), (Predicate)LocationPredicates.idEquals((String)dataCenter.location().getId()));
        float size = 0.0f;
        ArrayList volumes = Lists.newArrayList();
        List<Storage> storages = server.storages();
        if (storages != null) {
            for (Storage storage : storages) {
                size += storage.size();
                volumes.add(this.fnVolume.apply((Object)storage));
            }
        }
        String id = String.format("cpu=%d,ram=%d,disk=%.0f", server.cores(), server.ram(), Float.valueOf(size));
        Hardware hardware = new HardwareBuilder().ids(id).name(id).ram(server.ram().intValue()).processor(new Processor((double)server.cores().intValue(), 1.0)).hypervisor("kvm").volumes((Iterable)volumes).location(location).build();
        List addresses = (List)this.fnCollectIps.apply(server.nics());
        NodeMetadataBuilder nodeBuilder = new NodeMetadataBuilder();
        nodeBuilder.ids(server.id()).group(this.groupNamingConvention.extractGroup(server.name())).hostname(server.hostname()).name(server.name()).backendStatus(server.state().toString()).status(ServerToNodeMetadata.mapStatus(server.status())).hardware(hardware).operatingSystem(ServerToNodeMetadata.mapOsType(server.osType())).location(location).privateAddresses(Iterables.filter((Iterable)addresses, (Predicate)InetAddresses2.IsPrivateIPAddress.INSTANCE)).publicAddresses(Iterables.filter((Iterable)addresses, (Predicate)Predicates.not((Predicate)InetAddresses2.IsPrivateIPAddress.INSTANCE)));
        return nodeBuilder.build();
    }

    static NodeMetadata.Status mapStatus(Server.Status status) {
        if (status == null) {
            return NodeMetadata.Status.UNRECOGNIZED;
        }
        switch (status) {
            case SHUTDOWN: 
            case SHUTOFF: 
            case PAUSED: {
                return NodeMetadata.Status.SUSPENDED;
            }
            case RUNNING: {
                return NodeMetadata.Status.RUNNING;
            }
            case BLOCKED: {
                return NodeMetadata.Status.PENDING;
            }
            case CRASHED: {
                return NodeMetadata.Status.ERROR;
            }
        }
        return NodeMetadata.Status.UNRECOGNIZED;
    }

    static OperatingSystem mapOsType(OsType osType) {
        if (osType != null) {
            switch (osType) {
                case WINDOWS: {
                    return OperatingSystem.builder().description(OsFamily.WINDOWS.value()).family(OsFamily.WINDOWS).build();
                }
                case LINUX: {
                    return OperatingSystem.builder().description(OsFamily.LINUX.value()).family(OsFamily.LINUX).build();
                }
            }
        }
        return OperatingSystem.builder().description(OsFamily.UNRECOGNIZED.value()).family(OsFamily.UNRECOGNIZED).build();
    }
}

