/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.features;

import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.dynect.v3.DynECTExceptions;
import org.jclouds.dynect.v3.domain.CreatePrimaryZone;
import org.jclouds.dynect.v3.domain.Job;
import org.jclouds.dynect.v3.domain.Zone;
import org.jclouds.dynect.v3.filters.AlwaysAddContentType;
import org.jclouds.dynect.v3.filters.SessionManager;
import org.jclouds.dynect.v3.functions.ExtractLastPathComponent;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@Headers(keys={"API-Version"}, values={"{jclouds.api-version}"})
@RequestFilters(value={AlwaysAddContentType.class, SessionManager.class})
public interface ZoneApi {
    @Named(value="ListZones")
    @GET
    @Path(value="/Zone")
    @SelectJson(value={"data"})
    @Transform(value=ExtractLastPathComponent.class)
    public FluentIterable<String> list() throws DynECTExceptions.JobStillRunningException;

    @Named(value="CreatePrimaryZone")
    @POST
    @Path(value="/Zone/{fqdn}")
    @Consumes(value={"application/json"})
    public Job scheduleCreate(@PathParam(value="fqdn") @ParamParser(value=CreatePrimaryZone.ToFQDN.class) @BinderParam(value=BindToJsonPayload.class) CreatePrimaryZone var1) throws DynECTExceptions.JobStillRunningException, DynECTExceptions.TargetExistsException;

    @Named(value="CreatePrimaryZone")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="%7B\"rname\":\"{contact}\",\"serial_style\":\"increment\",\"ttl\":3600%7D")
    @Path(value="/Zone/{fqdn}")
    @Consumes(value={"application/json"})
    public Job scheduleCreateWithContact(@PathParam(value="fqdn") String var1, @PayloadParam(value="contact") String var2) throws DynECTExceptions.JobStillRunningException, DynECTExceptions.TargetExistsException;

    @Named(value="GetZone")
    @GET
    @Path(value="/Zone/{fqdn}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Zone get(@PathParam(value="fqdn") String var1) throws DynECTExceptions.JobStillRunningException;

    @Named(value="DeleteZone")
    @DELETE
    @Path(value="/Zone/{fqdn}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    @Nullable
    public Job delete(@PathParam(value="fqdn") String var1) throws DynECTExceptions.JobStillRunningException;

    @Named(value="DeleteZoneChanges")
    @DELETE
    @Path(value="/ZoneChanges/{fqdn}")
    @Consumes(value={"application/json"})
    public Job deleteChanges(@PathParam(value="fqdn") String var1) throws DynECTExceptions.JobStillRunningException;

    @Named(value="PublishZone")
    @PUT
    @Path(value="/Zone/{fqdn}")
    @Produces(value={"application/json"})
    @Payload(value="{\"publish\":true}")
    @SelectJson(value={"data"})
    public Zone publish(@PathParam(value="fqdn") String var1) throws DynECTExceptions.JobStillRunningException, ResourceNotFoundException;

    @Named(value="FreezeZone")
    @PUT
    @Path(value="/Zone/{fqdn}")
    @Produces(value={"application/json"})
    @Payload(value="{\"freeze\":true}")
    @Consumes(value={"application/json"})
    public Job freeze(@PathParam(value="fqdn") String var1) throws DynECTExceptions.JobStillRunningException;

    @Named(value="ThawZone")
    @PUT
    @Path(value="/Zone/{fqdn}")
    @Produces(value={"application/json"})
    @Payload(value="{\"thaw\":true}")
    @Consumes(value={"application/json"})
    public Job thaw(@PathParam(value="fqdn") String var1) throws DynECTExceptions.JobStillRunningException;
}

