/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.VCloudApi;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.network.OrgNetwork;

@Singleton
public class NetworksInOrg
implements Function<Org, Iterable<OrgNetwork>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudApi aclient;

    @Inject
    NetworksInOrg(VCloudApi aclient) {
        this.aclient = aclient;
    }

    public Iterable<OrgNetwork> apply(Org org) {
        return Iterables.transform(org.getNetworks().values(), (Function)new Function<ReferenceType, OrgNetwork>(){

            public OrgNetwork apply(ReferenceType from) {
                return NetworksInOrg.this.aclient.getNetworkApi().getNetwork(from.getHref());
            }
        });
    }
}

