/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.VCloudApi;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;

@Singleton
public class CatalogsInOrg
implements Function<Org, Iterable<Catalog>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudApi aclient;

    @Inject
    CatalogsInOrg(VCloudApi aclient) {
        this.aclient = aclient;
    }

    public Iterable<Catalog> apply(Org org) {
        return Iterables.transform(org.getCatalogs().values(), (Function)new Function<ReferenceType, Catalog>(){

            public Catalog apply(ReferenceType from) {
                return CatalogsInOrg.this.aclient.getCatalogApi().getCatalog(from.getHref());
            }
        });
    }
}

