/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.binders.BindToStringPayload;

@Singleton
public class BindCPUCountToXmlPayload
extends BindToStringPayload {
    protected final String ns;
    protected final String schema;
    private static final String RESOURCE_ALLOCATION_NS = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData";

    @Inject
    public BindCPUCountToXmlPayload(BindToStringPayload stringBinder, @Named(value="jclouds.vcloud.xml.ns") String ns, @Named(value="jclouds.vcloud.xml.schema") String schema) {
        this.ns = ns;
        this.schema = schema;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)payload, (Object)"cpuCount") instanceof Integer), (Object)"this binder is only valid for Integers!");
        Integer cpuCount = (Integer)Integer.class.cast(payload);
        try {
            XMLBuilder cpuItem = XMLBuilder.create((String)"Item").a("xmlns", this.ns).a("xmlns:rasd", RESOURCE_ALLOCATION_NS);
            cpuItem.e("rasd:AllocationUnits").t("hertz * 10^6");
            cpuItem.e("rasd:Description").t("Number of Virtual CPUs");
            cpuItem.e("rasd:ElementName").t(cpuCount.toString() + " virtual CPU(s)");
            cpuItem.e("rasd:InstanceID").t("4");
            cpuItem.e("rasd:ResourceType").t(ResourceAllocationSettingData.ResourceType.PROCESSOR.value());
            cpuItem.e("rasd:VirtualQuantity").t(cpuCount.toString());
            cpuItem.e("rasd:Weight").t("0");
            Properties outputProperties = new Properties();
            outputProperties.put("omit-xml-declaration", "yes");
            request = super.bindToRequest(request, (Object)cpuItem.asString(outputProperties));
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        return request;
    }
}

