/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.suppliers;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.NoSuchElementException;
import org.easymock.EasyMock;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.suppliers.OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefaultTest")
public class OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefaultTest {
    ValueOfConfigurationKeyOrNull valueOfConfigurationKeyOrNull = (ValueOfConfigurationKeyOrNull)Guice.createInjector((Module[])new Module[0]).getInstance(ValueOfConfigurationKeyOrNull.class);

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIllegalArgumentWhenResourcesEmpty() {
        new OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault(this.valueOfConfigurationKeyOrNull, "foo", Predicates.alwaysTrue()).apply((Iterable)ImmutableSet.of());
    }

    @Test
    public void testReturnsOnlyResource() {
        ReferenceType reference = (ReferenceType)EasyMock.createMock(ReferenceType.class);
        Assert.assertEquals((Object)new OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault(this.valueOfConfigurationKeyOrNull, "foo", Predicates.alwaysTrue()).apply((Iterable)ImmutableSet.of((Object)reference)), (Object)reference);
    }

    @Test
    public void testReturnsFirstResourceWhenConfigurationUnspecified() {
        ReferenceType reference1 = (ReferenceType)EasyMock.createMock(ReferenceType.class);
        ReferenceType reference2 = (ReferenceType)EasyMock.createMock(ReferenceType.class);
        Assert.assertEquals((Object)new OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault(this.valueOfConfigurationKeyOrNull, "foo", Predicates.alwaysTrue()).apply((Iterable)ImmutableList.of((Object)reference1, (Object)reference2)), (Object)reference1);
    }

    @Test
    public void testReturnsResourceMatchingDefaultPredicateWhenConfigurationUnspecified() {
        ReferenceType reference1 = (ReferenceType)EasyMock.createMock(ReferenceType.class);
        ReferenceType reference2 = (ReferenceType)EasyMock.createMock(ReferenceType.class);
        Assert.assertEquals((Object)new OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault(this.valueOfConfigurationKeyOrNull, "foo", Predicates.equalTo((Object)reference2)).apply((Iterable)ImmutableList.of((Object)reference1, (Object)reference2)), (Object)reference2);
    }

    @Test
    public void testReturnsResourceWithNameMatchingConfigurationKey() {
        ReferenceTypeImpl reference1 = new ReferenceTypeImpl("travis tritt", null, null);
        ReferenceTypeImpl reference2 = new ReferenceTypeImpl("hail mary", null, null);
        Assert.assertEquals((Object)new OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault((ValueOfConfigurationKeyOrNull)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"foo")).to(".*mary.*");
            }
        }}).getInstance(ValueOfConfigurationKeyOrNull.class), "foo", Predicates.alwaysTrue()).apply((Iterable)ImmutableList.of((Object)reference1, (Object)reference2)), (Object)reference2);
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testThrowsNoSuchElementWhenNoneMatchConfigurationKey() {
        ReferenceTypeImpl reference1 = new ReferenceTypeImpl("travis tritt", null, null);
        ReferenceTypeImpl reference2 = new ReferenceTypeImpl("hail mary", null, null);
        new OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault((ValueOfConfigurationKeyOrNull)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"foo")).to(".*happy.*");
            }
        }}).getInstance(ValueOfConfigurationKeyOrNull.class), "foo", Predicates.alwaysTrue()).apply((Iterable)ImmutableList.of((Object)reference1, (Object)reference2));
    }
}

