/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.vcloud.binders.BindCatalogItemToXmlPayload;
import org.jclouds.vcloud.internal.BasePayloadTest;
import org.jclouds.vcloud.options.CatalogItemOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindCatalogItemToXmlPayloadTest
extends BasePayloadTest {
    public void testDefault() throws IOException {
        String expected = "<CatalogItem xmlns=\"http://www.vmware.com/vcloud/v1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" name=\"myname\" xsi:schemaLocation=\"http://www.vmware.com/vcloud/v1 http://vcloud.safesecureweb.com/ns/vcloud.xsd\"><Description>mydescription</Description><Entity href=\"http://fooentity\"/><Property key=\"foo\">bar</Property></CatalogItem>";
        CatalogItemOptions options = CatalogItemOptions.Builder.description((String)"mydescription").properties((Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of((Object)options));
        BindCatalogItemToXmlPayload binder = (BindCatalogItemToXmlPayload)this.injector.getInstance(BindCatalogItemToXmlPayload.class);
        ImmutableMap map = ImmutableMap.of((Object)"name", (Object)"myname", (Object)"Entity", (Object)"http://fooentity");
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map)).getPayload().getRawContent(), (Object)expected);
    }
}

