/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.VApp;
import org.jclouds.vcloud.domain.Vm;
import org.jclouds.vcloud.domain.internal.VAppImpl;
import org.jclouds.vcloud.domain.ovf.VCloudNetworkSection;
import org.jclouds.vcloud.util.Utils;
import org.jclouds.vcloud.xml.TaskHandler;
import org.jclouds.vcloud.xml.VmHandler;
import org.jclouds.vcloud.xml.ovf.VCloudNetworkSectionHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VAppHandler
extends ParseSax.HandlerWithResult<VApp> {
    protected final TaskHandler taskHandler;
    protected final VmHandler vmHandler;
    protected final VCloudNetworkSectionHandler networkSectionHandler;
    protected StringBuilder currentText = new StringBuilder();
    protected ReferenceType template;
    protected Status status;
    protected ReferenceType vdc;
    protected String description;
    protected List<Task> tasks = Lists.newArrayList();
    protected boolean ovfDescriptorUploaded = true;
    private boolean inChildren;
    private boolean inTasks;
    private boolean inNetworkSection;
    protected Set<Vm> children = Sets.newLinkedHashSet();
    private VCloudNetworkSection networkSection;
    protected int depth = 0;

    @Inject
    public VAppHandler(TaskHandler taskHandler, VmHandler vmHandler, VCloudNetworkSectionHandler networkSectionHandler) {
        this.taskHandler = taskHandler;
        this.vmHandler = vmHandler;
        this.networkSectionHandler = networkSectionHandler;
    }

    public VApp getResult() {
        return new VAppImpl(this.template.getName(), this.template.getType(), this.template.getHref(), this.status, this.vdc, this.description, this.tasks, this.ovfDescriptorUploaded, this.children, this.networkSection);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        ++this.depth;
        if (this.depth == 2) {
            if (SaxUtils.equalsOrSuffix((String)qName, (String)"Children")) {
                this.inChildren = true;
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Tasks")) {
                this.inTasks = true;
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"NetworkSection")) {
                this.inNetworkSection = true;
            }
        }
        if (this.inChildren) {
            this.vmHandler.startElement(uri, localName, qName, attrs);
        } else if (this.inTasks) {
            this.taskHandler.startElement(uri, localName, qName, attrs);
        } else if (this.inNetworkSection) {
            this.networkSectionHandler.startElement(uri, localName, qName, attrs);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"VApp")) {
            this.template = Utils.newReferenceType(attributes);
            if (attributes.containsKey("status")) {
                this.status = Status.fromValue(Integer.parseInt((String)attributes.get("status")));
            }
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Link") && "up".equals(attributes.get("rel"))) {
            this.vdc = Utils.newReferenceType(attributes);
        }
    }

    public void endElement(String uri, String name, String qName) {
        --this.depth;
        if (this.depth == 1) {
            if (SaxUtils.equalsOrSuffix((String)qName, (String)"Children")) {
                this.inChildren = false;
                this.children.add(this.vmHandler.getResult());
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Tasks")) {
                this.inTasks = false;
                this.tasks.add(this.taskHandler.getResult());
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Description")) {
                this.description = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"NetworkSection")) {
                this.inNetworkSection = false;
                this.networkSection = this.networkSectionHandler.getResult();
            }
        }
        if (this.inChildren) {
            this.vmHandler.endElement(uri, name, qName);
        } else if (this.inTasks) {
            this.taskHandler.endElement(uri, name, qName);
        } else if (this.inNetworkSection) {
            this.networkSectionHandler.endElement(uri, name, qName);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ovfDescriptorUploaded")) {
            this.ovfDescriptorUploaded = Boolean.parseBoolean(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inTasks) {
            this.taskHandler.characters(ch, start, length);
        } else if (this.inChildren) {
            this.vmHandler.characters(ch, start, length);
        } else if (this.inNetworkSection) {
            this.networkSectionHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

