/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.VCloudApi;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.ReferenceType;

@Singleton
public class CatalogItemsInCatalog
implements Function<Catalog, Iterable<CatalogItem>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudApi aclient;

    @Inject
    CatalogItemsInCatalog(VCloudApi aclient) {
        this.aclient = aclient;
    }

    public Iterable<CatalogItem> apply(Catalog from) {
        return Iterables.transform((Iterable)Iterables.filter(from.values(), (Predicate)new Predicate<ReferenceType>(){

            public boolean apply(ReferenceType input) {
                return input.getType().equals("application/vnd.vmware.vcloud.catalogItem+xml");
            }
        }), (Function)new Function<ReferenceType, CatalogItem>(){

            public CatalogItem apply(ReferenceType from) {
                return CatalogItemsInCatalog.this.aclient.getCatalogApi().getCatalogItem(from.getHref());
            }
        });
    }
}

