/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.features;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ovf.xml.EnvelopeHandler;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.Strings2;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.NetworkConfig;
import org.jclouds.vcloud.features.VAppTemplateApi;
import org.jclouds.vcloud.internal.BaseVCloudApiTest;
import org.jclouds.vcloud.options.CaptureVAppOptions;
import org.jclouds.vcloud.options.CloneVAppTemplateOptions;
import org.jclouds.vcloud.options.InstantiateVAppTemplateOptions;
import org.jclouds.vcloud.xml.TaskHandler;
import org.jclouds.vcloud.xml.VAppHandler;
import org.jclouds.vcloud.xml.VAppTemplateHandler;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VAppTemplateApiTest")
public class VAppTemplateApiTest
extends BaseVCloudApiTest<VAppTemplateApi> {
    public void testCreateVAppInVDCByInstantiatingTemplate() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppTemplateApi.class, (String)"createVAppInVDCByInstantiatingTemplate", (Class[])new Class[]{String.class, URI.class, URI.class, InstantiateVAppTemplateOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"my-vapp", (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vdc/1"), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/3"), (Object)InstantiateVAppTemplateOptions.Builder.addNetworkConfig((NetworkConfig)new NetworkConfig("aloha", URI.create("https://vcenterprise.bluelock.com/api/v1.0/network/1991"), FenceMode.NAT_ROUTED))));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vdc/1/action/instantiateVAppTemplate HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vApp+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/instantiationparams-network.xml")), "application/vnd.vmware.vcloud.instantiateVAppTemplateParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VAppHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testCreateVAppInVDCByInstantiatingTemplateOptionsIllegalName() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppTemplateApi.class, (String)"createVAppInVDCByInstantiatingTemplate", (Class[])new Class[]{String.class, URI.class, URI.class, InstantiateVAppTemplateOptions[].class});
        this.processor.createRequest(method, (List)ImmutableList.of((Object)"CentOS 01", (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vdc/1"), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vdc/1"), (Object)InstantiateVAppTemplateOptions.Builder.addNetworkConfig((NetworkConfig)new NetworkConfig(null, URI.create("https://vcenterprise.bluelock.com/api/v1.0/network/1991"), null))));
    }

    public void testcopyVAppTemplateToVDCAndName() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppTemplateApi.class, (String)"copyVAppTemplateToVDCAndName", (Class[])new Class[]{URI.class, URI.class, String.class, CloneVAppTemplateOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/4181"), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vdc/1"), (Object)"my-vapptemplate"));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vdc/1/action/cloneVAppTemplate HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/copyVAppTemplate-default.xml")), "application/vnd.vmware.vcloud.cloneVAppTemplateParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testcopyVAppTemplateToVDCAndNameOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppTemplateApi.class, (String)"copyVAppTemplateToVDCAndName", (Class[])new Class[]{URI.class, URI.class, String.class, CloneVAppTemplateOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/201"), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vdc/1"), (Object)"new-linux-server", (Object)new CloneVAppTemplateOptions().description("The description of the new vAppTemplate")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vdc/1/action/cloneVAppTemplate HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/copyVAppTemplate.xml")), "application/vnd.vmware.vcloud.cloneVAppTemplateParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testmoveVAppTemplateToVDCAndRenameOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppTemplateApi.class, (String)"moveVAppTemplateToVDCAndRename", (Class[])new Class[]{URI.class, URI.class, String.class, CloneVAppTemplateOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/201"), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vdc/1"), (Object)"new-linux-server", (Object)new CloneVAppTemplateOptions().description("The description of the new vAppTemplate")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vdc/1/action/cloneVAppTemplate HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/moveVAppTemplate.xml")), "application/vnd.vmware.vcloud.cloneVAppTemplateParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testcaptureVAppAsTemplateInVDC() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppTemplateApi.class, (String)"captureVAppAsTemplateInVDC", (Class[])new Class[]{URI.class, String.class, URI.class, CaptureVAppOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vapp/4181"), (Object)"my-template", (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vdc/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vdc/1/action/captureVApp HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vAppTemplate+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/captureVApp-default.xml")), "application/vnd.vmware.vcloud.captureVAppParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VAppTemplateHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testcaptureVAppAsTemplateInVDCOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppTemplateApi.class, (String)"captureVAppAsTemplateInVDC", (Class[])new Class[]{URI.class, String.class, URI.class, CaptureVAppOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vapp/201"), (Object)"my-template", (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vdc/1"), (Object)new CaptureVAppOptions().withDescription("The description of the new vApp Template")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vdc/1/action/captureVApp HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vAppTemplate+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/captureVApp.xml")), "application/vnd.vmware.vcloud.captureVAppParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VAppTemplateHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testFindVAppTemplate() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppTemplateApi.class, (String)"findVAppTemplateInOrgCatalogNamed", (Class[])new Class[]{String.class, String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"org", (Object)"catalog", (Object)"template"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vAppTemplate+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VAppTemplateHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testVAppTemplateURI() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppTemplateApi.class, (String)"getVAppTemplate", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/2")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vAppTemplate+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VAppTemplateHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetOvfEnvelopeForVAppTemplate() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VAppTemplateApi.class, (String)"getOvfEnvelopeForVAppTemplate", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/2")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/2/ovf HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: text/xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, EnvelopeHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }
}

