/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.strategy;

import com.google.common.collect.ImmutableMap;
import com.jamesmurty.utils.XMLBuilder;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.vcloud.compute.BaseVCloudComputeServiceExpectTest;
import org.jclouds.vcloud.compute.options.VCloudTemplateOptions;
import org.jclouds.vcloud.compute.strategy.InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOn;
import org.jclouds.vcloud.domain.VApp;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true, testName="InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOnExpectTest")
public class InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOnExpectTest
extends BaseVCloudComputeServiceExpectTest {
    String ns = "http://www.vmware.com/vcloud/v1";
    Properties outputProperties;
    HttpResponse successfulVersion1_0InstantiatedVApp = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("HTTP/1.1 200 OK").payload(this.payloadFromResourceWithContentType("/instantiatedvapp.xml", "application/vnd.vmware.vcloud.vApp+xml"))).build();

    public InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOnExpectTest() {
        this.outputProperties = new Properties();
        this.outputProperties.put("omit-xml-declaration", "yes");
    }

    @Test(enabled=false)
    public void testCreateNodeUsingVCloud1_0ApiAgainstVCloudDirector1_5WhenVAppTemplateHasNetworkNamedNone() throws Exception {
        String group = "group";
        String name = "group-abcd";
        String instantiateXML = XMLBuilder.create((String)"InstantiateVAppTemplateParams").a("xmlns", this.ns).a("xmlns:ovf", "http://schemas.dmtf.org/ovf/envelope/1").a("deploy", "false").a("name", name).a("powerOn", "false").e("Description").up().e("InstantiationParams").e("NetworkConfigSection").e("ovf:Info").t("Configuration parameters for logical networks").up().e("NetworkConfig").a("networkName", "orgNet-jclouds-External").e("Configuration").e("ParentNetwork").a("href", "https://zone.myvcloud.com/api/v1.0/network/" + this.networkId).up().e("FenceMode").t("bridged").up().up().up().up().up().e("Source").a("href", "https://zone.myvcloud.com/api/v1.0/vAppTemplate/" + this.templateId).up().e("AllEULAsAccepted").t("true").up().asString(this.outputProperties);
        HttpRequest version1_0InstantiateWithNetworkNamedSameAsOrgNetwork = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://zone.myvcloud.com/api/v1.0/vdc/" + this.vdcId + "/action/instantiateVAppTemplate").addHeader("Accept", new String[]{"application/vnd.vmware.vcloud.vApp+xml"})).addHeader("x-vcloud-authorization", new String[]{this.sessionToken})).addHeader("Cookie", new String[]{"vcloud-token=" + this.sessionToken})).payload(InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOnExpectTest.payloadFromStringWithContentType((String)instantiateXML, (String)"application/vnd.vmware.vcloud.instantiateVAppTemplateParams+xml"))).build();
        ComputeService compute = (ComputeService)this.requestsSendResponses((Map)ImmutableMap.builder().put((Object)this.versionsRequest, (Object)this.versionsResponseFromVCD1_5).put((Object)this.version1_0LoginRequest, (Object)this.successfulVersion1_0LoginResponseFromVCD1_5WithSingleOrg).put((Object)this.version1_0GetOrgRequest, (Object)this.successfulVersion1_0GetOrgResponseFromVCD1_5WithSingleTasksListVDCAndNetwork).put((Object)this.version1_0GetCatalogRequest, (Object)this.successfulVersion1_0GetCatalogResponseFromVCD1_5WithSingleTemplate).put((Object)this.version1_0GetCatalogItemRequest, (Object)this.successfulVersion1_0GetCatalogItemResponseFromVCD1_5ForTemplate).put((Object)this.version1_0GetVDCRequest, (Object)this.successfulVersion1_0GetVDCResponseFromVCD1_5WithSingleTemplateAndNetwork).put((Object)this.version1_0GetVAppTemplateRequest, (Object)this.successfulVersion1_0GetVAppTemplateResponseFromVCD1_5WithSingleVMAndVDCParent).put((Object)this.version1_0GetOVFForVAppTemplateRequest, (Object)this.successfulVersion1_0GetOVFForVAppTemplateResponseFromVCD1_5WithSingleVM).put((Object)version1_0InstantiateWithNetworkNamedSameAsOrgNetwork, (Object)this.successfulVersion1_0InstantiatedVApp).build());
        InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOn starter = (InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOn)compute.getContext().utils().injector().getInstance(InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOn.class);
        ComputeServiceAdapter.NodeAndInitialCredentials appAndCreds = starter.createNodeWithGroupEncodedIntoName(group, name, compute.templateBuilder().build());
        Assert.assertEquals((String)((VApp)appAndCreds.getNode()).getName(), (String)name);
        Assert.assertEquals((Object)appAndCreds.getCredentials(), (Object)LoginCredentials.builder().user("root").password("fromVApp").build());
    }

    public void testInstantiateVAppFromTemplateWhenUsingOverriddenNetworkAndFenceMode() throws Exception {
        String name = "group-abcd";
        FenceMode fenceMode = FenceMode.NAT_ROUTED;
        URI parentNetwork = URI.create("https://zone.myvcloud.com/api/v1.0/network/foooooooo");
        String instantiateXML = XMLBuilder.create((String)"InstantiateVAppTemplateParams").a("xmlns", this.ns).a("xmlns:ovf", "http://schemas.dmtf.org/ovf/envelope/1").a("deploy", "false").a("name", name).a("powerOn", "false").e("Description").up().e("InstantiationParams").e("NetworkConfigSection").e("ovf:Info").t("Configuration parameters for logical networks").up().e("NetworkConfig").a("networkName", "jclouds").e("Configuration").e("ParentNetwork").a("href", parentNetwork.toASCIIString()).up().e("FenceMode").t(fenceMode.toString()).up().up().up().up().up().e("Source").a("href", "https://zone.myvcloud.com/api/v1.0/vAppTemplate/" + this.templateId).up().e("AllEULAsAccepted").t("true").up().asString(this.outputProperties);
        HttpRequest version1_0InstantiateWithCustomizedNetwork = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://zone.myvcloud.com/api/v1.0/vdc/" + this.vdcId + "/action/instantiateVAppTemplate").addHeader("Accept", new String[]{"application/vnd.vmware.vcloud.vApp+xml"})).addHeader("x-vcloud-authorization", new String[]{this.sessionToken})).addHeader("Cookie", new String[]{"vcloud-token=" + this.sessionToken})).payload(InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOnExpectTest.payloadFromStringWithContentType((String)instantiateXML, (String)"application/vnd.vmware.vcloud.instantiateVAppTemplateParams+xml"))).build();
        ComputeService compute = (ComputeService)this.requestsSendResponses((Map)ImmutableMap.builder().put((Object)this.versionsRequest, (Object)this.versionsResponseFromVCD1_5).put((Object)this.version1_0LoginRequest, (Object)this.successfulVersion1_0LoginResponseFromVCD1_5WithSingleOrg).put((Object)this.version1_0GetOrgRequest, (Object)this.successfulVersion1_0GetOrgResponseFromVCD1_5WithSingleTasksListVDCAndNetwork).put((Object)this.version1_0GetCatalogRequest, (Object)this.successfulVersion1_0GetCatalogResponseFromVCD1_5WithSingleTemplate).put((Object)this.version1_0GetCatalogItemRequest, (Object)this.successfulVersion1_0GetCatalogItemResponseFromVCD1_5ForTemplate).put((Object)this.version1_0GetVDCRequest, (Object)this.successfulVersion1_0GetVDCResponseFromVCD1_5WithSingleTemplateAndNetwork).put((Object)this.version1_0GetVAppTemplateRequest, (Object)this.successfulVersion1_0GetVAppTemplateResponseFromVCD1_5WithSingleVMAndVDCParent).put((Object)this.version1_0GetOVFForVAppTemplateRequest, (Object)this.successfulVersion1_0GetOVFForVAppTemplateResponseFromVCD1_5WithSingleVM).put((Object)version1_0InstantiateWithCustomizedNetwork, (Object)this.successfulVersion1_0InstantiatedVApp).build());
        InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOn starter = (InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOn)compute.getContext().utils().injector().getInstance(InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOn.class);
        Template template = compute.templateBuilder().build();
        ((VCloudTemplateOptions)template.getOptions().as(VCloudTemplateOptions.class)).parentNetwork(parentNetwork).fenceMode(fenceMode);
        starter.instantiateVAppFromTemplate(name, template);
    }
}

