/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.ImmutableSortedMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.SortedMap;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.xml.SupportedVersionsHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class SupportedVersionsHandlerTest {
    public void testApplyInputStream() {
        InputStream is = this.getClass().getResourceAsStream("/versions.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        SortedMap result = (SortedMap)factory.create((ParseSax.HandlerWithResult)injector.getInstance(SupportedVersionsHandler.class)).parse(is);
        Assert.assertEquals((Map)result, (Map)ImmutableSortedMap.of((Comparable)((Object)"0.8"), (Object)URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/login")));
    }
}

