/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import java.io.InputStream;
import java.net.URI;
import java.net.UnknownHostException;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.vcloud.domain.GuestCustomizationSection;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.xml.GuestCustomizationSectionHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GuestCustomizationSectionHandlerTest")
public class GuestCustomizationSectionHandlerTest
extends BaseHandlerTest {
    public void testDefault() throws UnknownHostException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/guestCustomization.xml");
        GuestCustomizationSection result = (GuestCustomizationSection)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(GuestCustomizationSectionHandler.class)).parse(is);
        GuestCustomizationSectionHandlerTest.checkGuestCustomization(result);
    }

    @Test(enabled=false)
    public static void checkGuestCustomization(GuestCustomizationSection result) {
        Assert.assertEquals((String)result.getType(), (String)"application/vnd.vmware.vcloud.guestCustomizationSection+xml");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/vm-2087535248/guestCustomizationSection/"));
        Assert.assertEquals((String)result.getInfo(), (String)"Specifies Guest OS Customization Settings");
        Assert.assertEquals((Object)result.isEnabled(), (Object)Boolean.TRUE);
        Assert.assertEquals((Object)result.shouldChangeSid(), (Object)Boolean.FALSE);
        Assert.assertEquals((String)result.getVirtualMachineId(), (String)"2087535248");
        Assert.assertEquals((Object)result.isJoinDomainEnabled(), (Object)Boolean.FALSE);
        Assert.assertEquals((Object)result.useOrgSettings(), (Object)Boolean.FALSE);
        Assert.assertEquals((String)result.getDomainName(), null);
        Assert.assertEquals((String)result.getDomainUserName(), null);
        Assert.assertEquals((String)result.getDomainUserPassword(), null);
        Assert.assertEquals((Object)result.isAdminPasswordEnabled(), (Object)Boolean.TRUE);
        Assert.assertEquals((Object)result.isAdminPasswordAuto(), (Object)Boolean.TRUE);
        Assert.assertEquals((String)result.getAdminPassword(), null);
        Assert.assertEquals((Object)result.isResetPasswordRequired(), (Object)Boolean.FALSE);
        Assert.assertEquals((String)result.getCustomizationScript(), (String)"cat > /root/foo.txt<<EOF\nI '\"love\"' {asc|!}*&\nEOF\n");
        Assert.assertEquals((String)result.getComputerName(), (String)"RHEL5");
        Assert.assertEquals((Object)result.getEdit(), (Object)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.guestCustomizationSection+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/vm-2087535248/guestCustomizationSection/")));
    }
}

