/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.strategy;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.ComputeService;
import org.jclouds.vcloud.compute.BaseVCloudComputeServiceExpectTest;
import org.jclouds.vcloud.compute.strategy.VCloudComputeServiceAdapter;
import org.jclouds.vcloud.domain.VAppTemplate;
import org.testng.Assert;
import org.testng.annotations.Test;

public class VCloudComputeServiceAdapterTest
extends BaseVCloudComputeServiceExpectTest {
    @Test
    public void testListHardwareProfiles() throws Exception {
        ComputeService compute = (ComputeService)this.requestsSendResponses((Map)ImmutableMap.builder().put((Object)this.versionsRequest, (Object)this.versionsResponseFromVCD1_5).put((Object)this.version1_0LoginRequest, (Object)this.successfulVersion1_0LoginResponseFromVCD1_5WithSingleOrg).put((Object)this.version1_0GetOrgRequest, (Object)this.successfulVersion1_0GetOrgResponseFromVCD1_5WithSingleTasksListVDCAndNetwork).put((Object)this.version1_0GetCatalogRequest, (Object)this.successfulVersion1_0GetCatalogResponseFromVCD1_5WithSingleTemplate).put((Object)this.version1_0GetCatalogItemRequest, (Object)this.successfulVersion1_0GetCatalogItemResponseFromVCD1_5ForTemplate).put((Object)this.version1_0GetVDCRequest, (Object)this.successfulVersion1_0GetVDCResponseFromVCD1_5WithSingleTemplateAndNetwork).put((Object)this.version1_0GetVAppTemplateRequest, (Object)this.successfulVersion1_0GetVAppTemplateResponseFromVCD1_5WithSingleVMAndVDCParent).put((Object)this.version1_0GetOVFForVAppTemplateRequest, (Object)this.successfulVersion1_0GetOVFForVAppTemplateResponseFromVCD1_5WithSingleVM).build());
        VCloudComputeServiceAdapter adapter = (VCloudComputeServiceAdapter)compute.getContext().utils().injector().getInstance(VCloudComputeServiceAdapter.class);
        Iterable hardwareProfiles = adapter.listHardwareProfiles();
        Iterable hardwareProfileRefs = Iterables.transform((Iterable)ImmutableList.copyOf((Iterable)hardwareProfiles), (Function)new Function<VAppTemplate, URI>(){

            public URI apply(VAppTemplate input) {
                return input.getHref();
            }
        });
        Assert.assertEquals((Set)ImmutableSet.copyOf((Iterable)hardwareProfileRefs), (Set)ImmutableSet.of((Object)URI.create("https://zone.myvcloud.com/api/v1.0/vAppTemplate/vappTemplate-51891b97-c5dd-47dc-a687-aabae354f728")));
    }

    @Test
    public void testListHardwareProfilesWithUnsupportedTemplate() throws Exception {
        ComputeService compute = (ComputeService)this.requestsSendResponses((Map)ImmutableMap.builder().put((Object)this.versionsRequest, (Object)this.versionsResponseFromVCD1_5).put((Object)this.version1_0LoginRequest, (Object)this.successfulVersion1_0LoginResponseFromVCD1_5WithSingleOrg).put((Object)this.version1_0GetOrgRequest, (Object)this.successfulVersion1_0GetOrgResponseFromVCD1_5WithSingleTasksListVDCAndNetwork).put((Object)this.version1_0GetCatalogRequest, (Object)this.successfulVersion1_0GetCatalogResponseFromVCD1_5WithSingleTemplate).put((Object)this.version1_0GetCatalogItemRequest, (Object)this.successfulVersion1_0GetCatalogItemResponseFromVCD1_5ForTemplate).put((Object)this.version1_0GetVDCRequest, (Object)this.successfulVersion1_0GetVDCResponseFromVCD1_5WithSingleTemplateAndNetwork).put((Object)this.version1_0GetVAppTemplateRequest, (Object)this.successfulVersion1_0GetVAppTemplateResponseFromVCD1_5WithMultipleVMsAndVDCParent).put((Object)this.version1_0GetOVFForVAppTemplateRequest, (Object)this.successfulVersion1_0GetOVFForVAppTemplateResponseFromVCD1_5WithMultipleVMs).build());
        VCloudComputeServiceAdapter adapter = (VCloudComputeServiceAdapter)compute.getContext().utils().injector().getInstance(VCloudComputeServiceAdapter.class);
        Iterable hardwareProfiles = adapter.listHardwareProfiles();
        Assert.assertEquals((Set)ImmutableSet.copyOf((Iterable)hardwareProfiles), (Set)ImmutableSet.of());
    }
}

