/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import java.util.Map;

public class Message {
    private final String id;
    private final String body;
    private final String receiptHandle;
    private final HashCode md5;
    private final Map<String, String> attributes;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Message.builder().fromMessage(this);
    }

    private Message(String id, String body, String receiptHandle, HashCode md5, Map<String, String> attributes) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.body = (String)Preconditions.checkNotNull((Object)body, (String)"body of %s", (Object)id);
        this.receiptHandle = (String)Preconditions.checkNotNull((Object)receiptHandle, (String)"receiptHandle of %s", (Object)id);
        this.md5 = (HashCode)Preconditions.checkNotNull((Object)md5, (String)"md5 of %s", (Object)id);
        this.attributes = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(attributes, (String)"attributes of %s", (Object)id)));
    }

    public String getId() {
        return this.id;
    }

    public String getBody() {
        return this.body;
    }

    public String getReceiptHandle() {
        return this.receiptHandle;
    }

    public HashCode getMD5() {
        return this.md5;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Message that = (Message)Message.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("body", (Object)this.body).add("md5", (Object)this.md5).add("receiptHandle", (Object)this.receiptHandle).add("attributes", this.attributes).toString();
    }

    public static class Builder {
        private String id;
        private String body;
        private String receiptHandle;
        private HashCode md5;
        private ImmutableMap.Builder<String, String> attributes = ImmutableMap.builder();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder receiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
            return this;
        }

        public Builder md5(HashCode md5) {
            this.md5 = md5;
            return this;
        }

        public Builder attributes(Map<String, String> attributes) {
            this.attributes.putAll((Map)Preconditions.checkNotNull(attributes, (Object)"attributes"));
            return this;
        }

        public Builder addAttribute(String name, String value) {
            this.attributes.put(Preconditions.checkNotNull((Object)name, (Object)"name"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Message build() {
            return new Message(this.id, this.body, this.receiptHandle, this.md5, (Map)this.attributes.build());
        }

        public Builder fromMessage(Message in) {
            return this.id(in.getId()).body(in.getBody()).receiptHandle(in.getReceiptHandle()).md5(in.getMD5()).attributes(in.getAttributes());
        }
    }
}

