/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.config;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.config.AWSHttpApiModule;
import org.jclouds.aws.handlers.AWSClientErrorRetryHandler;
import org.jclouds.aws.handlers.AWSServerErrorRetryHandler;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.location.Region;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.RequestSigner;
import org.jclouds.s3.Bucket;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.blobstore.functions.BucketsToStorageMetadata;
import org.jclouds.s3.config.S3ObjectModule;
import org.jclouds.s3.config.S3ParserModule;
import org.jclouds.s3.domain.BucketMetadata;
import org.jclouds.s3.filters.RequestAuthorizeSignature;
import org.jclouds.s3.filters.RequestAuthorizeSignatureV2;
import org.jclouds.s3.filters.RequestAuthorizeSignatureV4;
import org.jclouds.s3.functions.GetRegionForBucket;
import org.jclouds.s3.handlers.ParseS3ErrorFromXmlContent;
import org.jclouds.s3.handlers.S3RedirectionRetryHandler;

@ConfiguresHttpApi
public class S3HttpApiModule<S extends S3Client>
extends AWSHttpApiModule<S> {
    public S3HttpApiModule() {
        this((Class)Class.class.cast(S3Client.class));
    }

    protected S3HttpApiModule(Class<S> syncClientType) {
        super(syncClientType);
    }

    @Provides
    @Bucket
    @Singleton
    protected final CacheLoader<String, Optional<String>> provideBucketToRegion(@Region Supplier<Set<String>> regionSupplier, S3Client client) {
        return this.bucketToRegion(regionSupplier, client);
    }

    protected CacheLoader<String, Optional<String>> bucketToRegion(@Region Supplier<Set<String>> regionSupplier, final S3Client client) {
        Set regions = (Set)regionSupplier.get();
        if (regions.isEmpty()) {
            return new CacheLoader<String, Optional<String>>(){

                public Optional<String> load(String bucket) {
                    return Optional.absent();
                }

                public String toString() {
                    return "noRegions()";
                }
            };
        }
        if (regions.size() == 1) {
            final String onlyRegion = (String)Iterables.getOnlyElement((Iterable)regions);
            return new CacheLoader<String, Optional<String>>(){
                Optional<String> onlyRegionOption;
                {
                    this.onlyRegionOption = Optional.of((Object)onlyRegion);
                }

                public Optional<String> load(String bucket) {
                    return this.onlyRegionOption;
                }

                public String toString() {
                    return "onlyRegion(" + onlyRegion + ")";
                }
            };
        }
        return new CacheLoader<String, Optional<String>>(){

            public Optional<String> load(String bucket) {
                try {
                    return Optional.fromNullable((Object)client.getBucketLocation(bucket));
                }
                catch (ContainerNotFoundException e) {
                    return Optional.absent();
                }
            }

            public String toString() {
                return "bucketToRegion()";
            }
        };
    }

    @Provides
    @Bucket
    @Singleton
    protected final LoadingCache<String, Optional<String>> bucketToRegion(@Bucket CacheLoader<String, Optional<String>> loader) {
        return CacheBuilder.newBuilder().build(loader);
    }

    @Provides
    @Bucket
    @Singleton
    protected final Supplier<String> provideDefaultRegionForBucket(@Region Supplier<String> defaultRegion) {
        return this.defaultRegionForBucket(defaultRegion);
    }

    protected Supplier<String> defaultRegionForBucket(@Region Supplier<String> defaultRegion) {
        return defaultRegion;
    }

    @Provides
    @Singleton
    @Bucket
    protected final Supplier<URI> provideBucketURI(@Bucket Supplier<String> defaultRegion, RegionToEndpointOrProviderIfNull regionToEndpoint) {
        return Suppliers.compose((Function)regionToEndpoint, defaultRegion);
    }

    protected void configure() {
        super.configure();
        this.install((Module)new S3ObjectModule());
        this.install((Module)new S3ParserModule());
        this.bind((TypeLiteral)new TypeLiteral<Function<String, Optional<String>>>(){}).annotatedWith(Bucket.class).to(GetRegionForBucket.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Set<BucketMetadata>, PageSet<? extends StorageMetadata>>>(){}).to(BucketsToStorageMetadata.class);
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseS3ErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseS3ErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseS3ErrorFromXmlContent.class);
    }

    @Provides
    @Singleton
    protected final RequestAuthorizeSignature provideRequestAuthorizeSignature(Injector i, @Named(value="jclouds.s3.signer-version") int version) {
        return this.providesRequestAuthorizeSignature(i, version);
    }

    protected RequestAuthorizeSignature providesRequestAuthorizeSignature(Injector i, int version) {
        switch (version) {
            case 2: {
                return (RequestAuthorizeSignature)i.getInstance(RequestAuthorizeSignatureV2.class);
            }
            case 4: {
                return (RequestAuthorizeSignature)i.getInstance(RequestAuthorizeSignatureV4.class);
            }
        }
        throw new IllegalStateException("version must be 2 or 4, was: " + version);
    }

    @Provides
    @Singleton
    protected final RequestSigner provideRequestSigner(RequestAuthorizeSignature in) {
        if (in instanceof RequestSigner) {
            return (RequestSigner)in;
        }
        return new RequestSigner(){

            public String createStringToSign(HttpRequest input) {
                return null;
            }

            public String sign(String toSign) {
                return null;
            }
        };
    }

    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(Redirection.class).to(S3RedirectionRetryHandler.class);
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(AWSClientErrorRetryHandler.class);
        this.bind(HttpRetryHandler.class).annotatedWith(ServerError.class).to(AWSServerErrorRetryHandler.class);
    }

    @Provides
    @TimeStamp
    protected final String guiceProvideTimeStamp(@TimeStamp Supplier<String> cache) {
        return this.provideTimeStamp(cache);
    }

    protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
        return (String)cache.get();
    }

    @Provides
    @TimeStamp
    @Singleton
    protected final Supplier<String> provideTimeStampCache(@Named(value="jclouds.session-interval") long seconds, final DateService dateService) {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<String>(){

            public String get() {
                return dateService.rfc822DateFormat();
            }
        }, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }

    @Provides
    @TimeStamp
    protected Date provideTimeStampDate(@TimeStamp Supplier<Date> cache) {
        return (Date)cache.get();
    }

    @Provides
    @TimeStamp
    @Singleton
    protected final Supplier<Date> guiceProvideTimeStampCacheDate(@Named(value="jclouds.session-interval") long seconds, @TimeStamp Supplier<String> timestamp, DateService dateService) {
        return this.provideTimeStampCacheDate(seconds, timestamp, dateService);
    }

    protected Supplier<Date> provideTimeStampCacheDate(@Named(value="jclouds.session-interval") long seconds, final @TimeStamp Supplier<String> timestamp, final DateService dateService) {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<Date>(){

            public Date get() {
                return dateService.rfc822DateParse((String)timestamp.get());
            }
        }, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }
}

