/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ConvertLB;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.LB;
import org.jclouds.rest.InvocationContext;

public class ParseLoadBalancer
implements Function<HttpResponse, LoadBalancer>,
InvocationContext<ParseLoadBalancer> {
    private final ParseJson<Map<String, LB>> json;
    private final ConvertLB.Factory factory;
    private ConvertLB convertLB;

    @Inject
    ParseLoadBalancer(ParseJson<Map<String, LB>> json, ConvertLB.Factory factory) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
        this.factory = (ConvertLB.Factory)Preconditions.checkNotNull((Object)factory, (Object)"factory");
    }

    public LoadBalancer apply(HttpResponse arg0) {
        Preconditions.checkState((this.convertLB != null ? 1 : 0) != 0, (Object)"convertLB should be set by InvocationContext");
        Map map = (Map)this.json.apply(arg0);
        if (map == null || map.isEmpty()) {
            return null;
        }
        LB lb = (LB)Iterables.get(map.values(), (int)0);
        return this.convertLB.apply(lb);
    }

    public ParseLoadBalancer setContext(HttpRequest request) {
        return this.setEndpointAndRegion(request.getEndpoint());
    }

    ParseLoadBalancer setEndpointAndRegion(URI endpoint) {
        String region = endpoint.getHost().substring(0, endpoint.getHost().indexOf(46));
        this.convertLB = this.factory.createForEndpointAndRegion(endpoint, region);
        return this;
    }
}

