/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class AccessRule {
    private final Type type;
    private final String address;

    public static AccessRule allow(String address) {
        return new AccessRule(address, Type.ALLOW);
    }

    public static AccessRule deny(String address) {
        return new AccessRule(address, Type.DENY);
    }

    public AccessRule(String address, Type type) {
        this.address = (String)Preconditions.checkNotNull((Object)address, (Object)"address");
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
    }

    public String getAddress() {
        return this.address;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.address});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AccessRule that = (AccessRule)AccessRule.class.cast(obj);
        return Objects.equal((Object)this.address, (Object)that.address);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("address", (Object)this.address).add("type", (Object)this.type);
    }

    public String toString() {
        return this.string().toString();
    }

    public static enum Type {
        ALLOW,
        DENY,
        UNRECOGNIZED;


        public static Type fromValue(String type) {
            try {
                return Type.valueOf((String)Preconditions.checkNotNull((Object)type, (Object)"type"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

