/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1;

import com.google.inject.Provides;
import java.io.Closeable;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.location.Region;
import org.jclouds.location.functions.RegionToEndpoint;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.AccessRuleApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.ConnectionApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.ContentCachingApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.ErrorPageApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.HealthMonitorApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.LoadBalancerApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.NodeApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.ReportApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.SSLTerminationApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.SessionPersistenceApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.VirtualIPApi;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.annotations.EndpointParam;

public interface CloudLoadBalancersApi
extends Closeable {
    @Provides
    @Region
    public Set<String> getConfiguredRegions();

    @Delegate
    public LoadBalancerApi getLoadBalancerApi(@EndpointParam(parser=RegionToEndpoint.class) String var1);

    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public NodeApi getNodeApi(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="lbId") int var2);

    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public AccessRuleApi getAccessRuleApi(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="lbId") int var2);

    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public VirtualIPApi getVirtualIPApi(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="lbId") int var2);

    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public ConnectionApi getConnectionApi(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="lbId") int var2);

    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public HealthMonitorApi getHealthMonitorApi(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="lbId") int var2);

    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public SessionPersistenceApi getSessionPersistenceApi(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="lbId") int var2);

    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public ContentCachingApi getContentCachingApi(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="lbId") int var2);

    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public SSLTerminationApi getSSLTerminationApi(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="lbId") int var2);

    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public ErrorPageApi getErrorPageApi(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="lbId") int var2);

    @Delegate
    public ReportApi getReportApi(@EndpointParam(parser=RegionToEndpoint.class) String var1);

    @Deprecated
    @Provides
    @Region
    public Set<String> getConfiguredZones();

    @Deprecated
    @Delegate
    public LoadBalancerApi getLoadBalancerApiForZone(@EndpointParam(parser=RegionToEndpoint.class) String var1);

    @Deprecated
    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public NodeApi getNodeApiForZoneAndLoadBalancer(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="lbId") int var2);

    @Deprecated
    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public AccessRuleApi getAccessRuleApiForZoneAndLoadBalancer(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="lbId") int var2);

    @Deprecated
    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public VirtualIPApi getVirtualIPApiForZoneAndLoadBalancer(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="lbId") int var2);

    @Deprecated
    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public ConnectionApi getConnectionApiForZoneAndLoadBalancer(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="lbId") int var2);

    @Deprecated
    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public HealthMonitorApi getHealthMonitorApiForZoneAndLoadBalancer(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="lbId") int var2);

    @Deprecated
    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public SessionPersistenceApi getSessionPersistenceApiForZoneAndLoadBalancer(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="lbId") int var2);

    @Deprecated
    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public ContentCachingApi getContentCachingApiForZoneAndLoadBalancer(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="lbId") int var2);

    @Deprecated
    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public SSLTerminationApi getSSLTerminationApiForZoneAndLoadBalancer(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="lbId") int var2);

    @Deprecated
    @Delegate
    @Path(value="/loadbalancers/{lbId}")
    public ErrorPageApi getErrorPageApiForZoneAndLoadBalancer(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="lbId") int var2);

    @Deprecated
    @Delegate
    public ReportApi getReportApiForZone(@EndpointParam(parser=RegionToEndpoint.class) String var1);
}

