/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rackspace.clouddns.v1.CloudDNSApi;
import org.jclouds.rackspace.clouddns.v1.domain.Domain;
import org.jclouds.rackspace.clouddns.v1.features.DomainApi;

@Beta
public class DomainsToPagedIterable
extends Arg0ToPagedIterable<Domain, DomainsToPagedIterable> {
    private final DomainApi api;

    @Inject
    protected DomainsToPagedIterable(CloudDNSApi api) {
        this.api = ((CloudDNSApi)Preconditions.checkNotNull((Object)api, (Object)"api")).getDomainApi();
    }

    protected Function<Object, IterableWithMarker<Domain>> markerToNextForArg0(Optional<Object> arg0) {
        return new ListDomainsAtMarker(this.api);
    }

    private static class ListDomainsAtMarker
    implements Function<Object, IterableWithMarker<Domain>> {
        private final DomainApi api;

        @Inject
        protected ListDomainsAtMarker(DomainApi api) {
            this.api = (DomainApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        public PaginatedCollection<Domain> apply(Object input) {
            PaginationOptions paginationOptions = (PaginationOptions)input;
            return this.api.list(paginationOptions);
        }

        public String toString() {
            return "ListDomainsAtMarker";
        }
    }
}

