/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.domain.OSType;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.functions.ParseIdToNameEntryFromHttpResponse;
import org.jclouds.cloudstack.functions.ParseIdToNameFromHttpResponse;
import org.jclouds.cloudstack.options.ListOSTypesOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface GuestOSApi {
    @Named(value="listOsTypes")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listOsTypes", "true"})
    @SelectJson(value={"ostype"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<OSType> listOSTypes(ListOSTypesOptions ... var1);

    @Named(value="listOsTypes")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listOsTypes", "true"})
    @SelectJson(value={"ostype"})
    @OnlyElement
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public OSType getOSType(@QueryParam(value="id") String var1);

    @Named(value="listOsCategories")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listOsCategories", "true"})
    @ResponseParser(value=ParseIdToNameFromHttpResponse.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Map<String, String> listOSCategories();

    @Named(value="listOsCategories")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listOsCategories", "true"})
    @ResponseParser(value=ParseIdToNameEntryFromHttpResponse.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Map.Entry<String, String> getOSCategory(@QueryParam(value="id") String var1);
}

