/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.httpclient;

import feign.Response;
import java.util.List;
import org.apache.james.webadmin.httpclient.FeignHelper;
import org.apache.james.webadmin.httpclient.feign.JamesFeignException;
import org.apache.james.webadmin.httpclient.feign.UserFeignClient;
import org.apache.james.webadmin.httpclient.model.UserName;
import org.apache.james.webadmin.httpclient.model.UserPassword;

public class UserClient {
    private final UserFeignClient feignClient;

    public UserClient(UserFeignClient feignClient) {
        this.feignClient = feignClient;
    }

    public List<UserName> getUserNameList() {
        return this.feignClient.getUserNameList();
    }

    public void createAUser(String username, String password) {
        try (Response response = this.feignClient.createAUser(username, new UserPassword(password));){
            switch (response.status()) {
                case 204: {
                    return;
                }
                case 400: {
                    throw new JamesFeignException("The user name or the payload is invalid");
                }
                case 409: {
                    throw new JamesFeignException("The user already exists");
                }
            }
            throw new JamesFeignException("Create user failed. " + FeignHelper.extractBody(response));
        }
    }

    public void updateAUserPassword(String username, String password) {
        try (Response response = this.feignClient.updateAUserPassword(username, new UserPassword(password));){
            switch (response.status()) {
                case 204: {
                    return;
                }
                case 400: {
                    throw new JamesFeignException("The user name or the payload is invalid");
                }
            }
            throw new JamesFeignException("Update user failed. " + FeignHelper.extractBody(response));
        }
    }

    public void deleteAUser(String username) {
        try (Response response = this.feignClient.deleteAUser(username);){
            FeignHelper.checkResponse(response.status() == 204, "Delete a user failed. " + FeignHelper.extractBody(response));
        }
    }

    public boolean doesExist(String username) {
        try (Response response = this.feignClient.doesExist(username);){
            switch (response.status()) {
                case 200: {
                    boolean bl = true;
                    return bl;
                }
                case 404: {
                    boolean bl = false;
                    return bl;
                }
                case 400: {
                    throw new JamesFeignException("The user name is invalid.\nA user has two attributes: username and password. A valid user should satisfy these criteria:\n-  username and password cannot be null or empty\n-  username should not be longer than 255 characters\n-  username can not contain '/'\n-  username can not contain multiple domain delimiter('@')\n-  A username can have only a local part when virtualHosting is disabled. E.g.'myUser'\n-  When virtualHosting is enabled, a username should have a domain part, and the domain part should be concatenated after a domain delimiter('@'). E.g. 'myuser@james.org'");
                }
            }
            throw new JamesFeignException("Check exist user failed. " + FeignHelper.extractBody(response));
        }
    }
}

