/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.james.util.UnitParser;

public class DurationParser {
    private DurationParser() {
    }

    public static Duration parse(String rawString) throws NumberFormatException {
        return DurationParser.parse(rawString, ChronoUnit.MILLIS);
    }

    public static Duration parse(String rawString, ChronoUnit defaultUnit) throws NumberFormatException {
        UnitParser.ParsingResult parsingResult = UnitParser.parse(rawString);
        Duration unitAsDuration = parsingResult.getUnit().map(s -> Unit.parse(s).getDuration()).orElse(defaultUnit.getDuration());
        return DurationParser.computeDuration(unitAsDuration, parsingResult.getNumber());
    }

    private static Duration computeDuration(Duration unitAsDuration, long time) {
        Preconditions.checkArgument(time >= 0L, "Duration amount should be positive");
        return unitAsDuration.multipliedBy(time);
    }

    private static enum Unit {
        MILLI_SECONDS(ImmutableList.of("ms", "msec", "msecs"), ChronoUnit.MILLIS),
        SECONDS(ImmutableList.of("s", "sec", "secs", "second", "seconds"), ChronoUnit.SECONDS),
        MINUTES(ImmutableList.of("m", "min", "mins", "minute", "minutes"), ChronoUnit.MINUTES),
        HOURS(ImmutableList.of("h", "hour", "hours"), ChronoUnit.HOURS),
        DAYS(ImmutableList.of("d", "day", "days"), ChronoUnit.DAYS),
        WEEKS(ImmutableList.of("w", "week", "weeks"), ChronoUnit.WEEKS),
        MONTH(ImmutableList.of("month", "months"), ChronoUnit.MONTHS),
        YEARS(ImmutableList.of("y", "year", "years"), ChronoUnit.YEARS);

        private final List<String> validPatterns;
        private final ChronoUnit unit;

        public static ChronoUnit parse(String string) {
            return Arrays.stream(Unit.values()).filter(value -> value.validPatterns.contains(string.toLowerCase(Locale.US))).findFirst().map(entry -> entry.unit).orElseThrow(() -> new NumberFormatException("Unknown unit: " + string));
        }

        private Unit(List<String> validPatterns, ChronoUnit unit) {
            this.validPatterns = validPatterns;
            this.unit = unit;
        }
    }
}

