/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.mailbox;

import java.util.concurrent.Callable;
import org.apache.james.cli.mailbox.MailboxCommand;
import org.apache.james.webadmin.httpclient.MailboxClient;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"Show all mailboxes of a user"})
public class MailboxListCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    MailboxCommand mailboxCommand;
    @CommandLine.Parameters(description={"Username to be used"})
    String userName;

    @Override
    public Integer call() {
        try {
            MailboxClient mailboxClient = this.mailboxCommand.fullyQualifiedURL("/users");
            mailboxClient.getMailboxList(this.userName).forEach(mailboxName -> this.mailboxCommand.out.println(mailboxName.getMailboxName()));
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(this.mailboxCommand.err);
            return 1;
        }
    }
}

