/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.mailbox;

import java.io.PrintStream;
import java.util.concurrent.Callable;
import org.apache.james.cli.WebAdminCli;
import org.apache.james.cli.mailbox.MailboxCreateCommand;
import org.apache.james.cli.mailbox.MailboxDeleteAllCommand;
import org.apache.james.cli.mailbox.MailboxDeleteCommand;
import org.apache.james.cli.mailbox.MailboxExistCommand;
import org.apache.james.cli.mailbox.MailboxListCommand;
import org.apache.james.webadmin.httpclient.MailboxClient;
import org.apache.james.webadmin.httpclient.feign.MailboxFeignClient;
import picocli.CommandLine;

@CommandLine.Command(name="mailbox", description={"Manage Mailboxes"}, subcommands={MailboxCreateCommand.class, MailboxExistCommand.class, MailboxListCommand.class, MailboxDeleteCommand.class, MailboxDeleteAllCommand.class})
public class MailboxCommand
implements Callable<Integer> {
    protected final WebAdminCli webAdminCli;
    protected final PrintStream out;
    protected final PrintStream err;

    public MailboxCommand(PrintStream out, WebAdminCli webAdminCli, PrintStream err) {
        this.out = out;
        this.webAdminCli = webAdminCli;
        this.err = err;
    }

    @Override
    public Integer call() {
        return 0;
    }

    public MailboxClient fullyQualifiedURL(String partOfUrl) {
        return new MailboxClient(this.webAdminCli.feignClientFactory(this.err).target(MailboxFeignClient.class, this.webAdminCli.jamesUrl + partOfUrl));
    }
}

