/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.domain;

import java.util.concurrent.Callable;
import org.apache.james.cli.domain.DomainCommand;
import org.apache.james.webadmin.httpclient.DomainClient;
import picocli.CommandLine;

@CommandLine.Command(name="exist", description={"Check if a domain is exist"})
public class DomainExistCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    DomainCommand domainCommand;
    @CommandLine.Parameters
    String domainName;

    @Override
    public Integer call() {
        try {
            DomainClient domainClient = this.domainCommand.fullyQualifiedURL("/domains");
            if (domainClient.doesExist(this.domainName)) {
                this.domainCommand.out.println(this.domainName + " exists");
            } else {
                this.domainCommand.out.println(this.domainName + " does not exist");
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(this.domainCommand.err);
            return 1;
        }
    }
}

