/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.domain;

import java.util.concurrent.Callable;
import org.apache.james.cli.domain.DomainCommand;
import org.apache.james.webadmin.httpclient.DomainClient;
import org.apache.james.webadmin.httpclient.feign.JamesFeignException;
import picocli.CommandLine;

@CommandLine.Command(name="addAlias", description={"Create a new domain alias"})
public class AddDomainAliasCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    DomainCommand domainCommand;
    @CommandLine.Parameters(description={"Destination of the domain alias. This is the domain this alias belongs to."})
    String destinationDomain;
    @CommandLine.Parameters(description={"Source of the domain alias."})
    String sourceDomain;

    @Override
    public Integer call() {
        try {
            DomainClient domainClient = this.domainCommand.fullyQualifiedURL("/domains");
            domainClient.addADomainAlias(this.destinationDomain, this.sourceDomain);
            return 0;
        }
        catch (Exception e) {
            if (e instanceof JamesFeignException) {
                this.domainCommand.err.println(e.getMessage());
            } else {
                e.printStackTrace(this.domainCommand.err);
            }
            return 1;
        }
    }
}

