/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli;

import feign.Feign;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.james.cli.WebAdminHTTPClientUtil;
import org.apache.james.cli.domain.DomainCommand;
import org.apache.james.cli.mailbox.MailboxCommand;
import org.apache.james.cli.quota.QuotaCommand;
import org.apache.james.cli.user.UserCommand;
import picocli.CommandLine;

@CommandLine.Command(name="james-cli", description={"James Webadmin CLI"})
public class WebAdminCli
implements Callable<Integer> {
    public static final int CLI_FINISHED_SUCCEED = 0;
    public static final int CLI_FINISHED_FAILED = 1;
    @CommandLine.Option(names={"--url"}, description={"James server URL"}, defaultValue="http://127.0.0.1:8000")
    public String jamesUrl;
    @CommandLine.Option(names={"--jwt-token"}, description={"Authentication Token"})
    public String jwt;
    @CommandLine.Option(names={"--jwt-from-file"}, description={"Authentication Token from a file"})
    public String jwtFilePath;

    @Override
    public Integer call() {
        return 0;
    }

    public static void main(String[] args) {
        PrintStream out = System.out;
        PrintStream err = System.err;
        int exitCode = WebAdminCli.execute(out, err, args);
        System.exit(exitCode);
    }

    public static int execute(PrintStream out, PrintStream err, String[] args) {
        WebAdminCli parent = new WebAdminCli();
        return new CommandLine(parent).addSubcommand(new CommandLine.HelpCommand()).addSubcommand(new DomainCommand(out, parent, err)).addSubcommand(new UserCommand(out, parent, err)).addSubcommand(new MailboxCommand(out, parent, err)).addSubcommand(new QuotaCommand(out, parent, err)).execute(args);
    }

    public static int executeFluent(PrintStream out, PrintStream err, String ... args) {
        return WebAdminCli.execute(out, err, args);
    }

    public static int executeFluent(PrintStream out, PrintStream err, Collection<String> args) {
        return WebAdminCli.execute(out, err, (String[])args.stream().toArray(String[]::new));
    }

    public Feign.Builder feignClientFactory(PrintStream err) {
        return new WebAdminHTTPClientUtil(new WebAdminHTTPClientUtil.JwtToken(Optional.ofNullable(this.jwt), Optional.ofNullable(this.jwtFilePath), err)).builder();
    }
}

