/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mock.smtp.server.testing;

import java.util.UUID;
import org.apache.james.mock.smtp.server.ConfigurationClient;
import org.apache.james.util.Host;
import org.apache.james.util.docker.DockerContainer;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class MockSmtpServerExtension
implements AfterEachCallback,
BeforeAllCallback,
AfterAllCallback,
ParameterResolver {
    private final DockerMockSmtp dockerMockSmtp = new DockerMockSmtp();

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.dockerMockSmtp.start();
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        this.dockerMockSmtp.getConfigurationClient().cleanServer();
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        this.dockerMockSmtp.stop();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == DockerMockSmtp.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.dockerMockSmtp;
    }

    public DockerMockSmtp getMockSmtp() {
        return this.dockerMockSmtp;
    }

    public static class DockerMockSmtp {
        private static final Logger LOGGER = LoggerFactory.getLogger(DockerMockSmtp.class);
        private final DockerContainer mockSmtpServer = DockerContainer.fromName((String)"linagora/mock-smtp-server:0.6").withLogConsumer(outputFrame -> LOGGER.debug("MockSMTP: " + outputFrame.getUtf8String())).withExposedPorts(new Integer[]{25, 8000}).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Mock SMTP server started.*", (int)1)).withName("james-testing-mock-smtp-server-" + UUID.randomUUID());

        DockerMockSmtp() {
        }

        void start() {
            this.mockSmtpServer.start();
        }

        void stop() {
            this.mockSmtpServer.stop();
        }

        public ConfigurationClient getConfigurationClient() {
            return ConfigurationClient.from(Host.from((String)this.mockSmtpServer.getHostIp(), (int)this.mockSmtpServer.getMappedPort(8000)));
        }

        public String getIPAddress() {
            return this.mockSmtpServer.getContainerIp();
        }
    }
}

