/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mock.smtp.server.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum SMTPCommand {
    RCPT_TO("RCPT TO"),
    EHLO("EHLO"),
    MAIL_FROM("MAIL FROM"),
    DATA("DATA"),
    RSET("RSET"),
    VRFY("VRFY"),
    NOOP("NOOP"),
    QUIT("QUIT");

    private final String commandName;

    @JsonCreator
    public static SMTPCommand parse(String value) {
        return Arrays.stream(SMTPCommand.values()).filter(command -> command.commandName.equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("No command name associated with supplied value: " + value));
    }

    private SMTPCommand(String commandName) {
        this.commandName = commandName;
    }

    @JsonValue
    public String getCommandName() {
        return this.commandName;
    }
}

