/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mock.smtp.server.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.mock.smtp.server.model.Condition;
import org.apache.james.mock.smtp.server.model.Response;
import org.apache.james.mock.smtp.server.model.SMTPCommand;

@JsonDeserialize(builder=Builder.class)
public class MockSMTPBehavior {
    private final SMTPCommand smtpCommand;
    private final Condition condition;
    private final Response response;
    private final NumberOfAnswersPolicy numberOfAnswers;

    public MockSMTPBehavior(SMTPCommand smtpCommand, Condition condition, Response response, NumberOfAnswersPolicy numberOfAnswers) {
        Preconditions.checkNotNull((Object)((Object)smtpCommand));
        Preconditions.checkNotNull((Object)condition);
        Preconditions.checkNotNull((Object)response);
        Preconditions.checkNotNull((Object)numberOfAnswers);
        this.smtpCommand = smtpCommand;
        this.condition = condition;
        this.response = response;
        this.numberOfAnswers = numberOfAnswers;
    }

    public SMTPCommand getCommand() {
        return this.smtpCommand;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public Response getResponse() {
        return this.response;
    }

    public NumberOfAnswersPolicy getNumberOfAnswer() {
        return this.numberOfAnswers;
    }

    public final boolean equals(Object o) {
        if (o instanceof MockSMTPBehavior) {
            MockSMTPBehavior that = (MockSMTPBehavior)o;
            return Objects.equals((Object)this.smtpCommand, (Object)that.smtpCommand) && Objects.equals(this.condition, that.condition) && Objects.equals(this.response, that.response) && Objects.equals(this.numberOfAnswers, that.numberOfAnswers);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.smtpCommand, this.condition, this.response, this.numberOfAnswers});
    }

    public String toString() {
        return "MockSMTPBehavior{smtpCommand=" + this.smtpCommand + ", condition=" + this.condition + ", response=" + this.response + ", numberOfAnswers=" + this.numberOfAnswers + "}";
    }

    public static final class NumberOfAnswersPolicy {
        private final Optional<Integer> numberOfAnswers;

        public static NumberOfAnswersPolicy anytime() {
            return new NumberOfAnswersPolicy(Optional.empty());
        }

        @JsonCreator
        public static NumberOfAnswersPolicy times(int times) {
            Preconditions.checkArgument((times > 0 ? 1 : 0) != 0, (Object)"times should be positive");
            return new NumberOfAnswersPolicy(Optional.of(times));
        }

        private NumberOfAnswersPolicy(Optional<Integer> numberOfAnswers) {
            this.numberOfAnswers = numberOfAnswers;
        }

        @JsonValue
        public Optional<Integer> getNumberOfAnswers() {
            return this.numberOfAnswers;
        }

        public final boolean equals(Object o) {
            if (o instanceof NumberOfAnswersPolicy) {
                NumberOfAnswersPolicy that = (NumberOfAnswersPolicy)o;
                return Objects.equals(this.numberOfAnswers, that.numberOfAnswers);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.numberOfAnswers);
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private SMTPCommand smtpCommand;
        private Condition condition;
        private Response response;
        private Optional<NumberOfAnswersPolicy> numberOfAnswers = Optional.empty();

        public Builder command(SMTPCommand command) {
            this.smtpCommand = command;
            return this;
        }

        public Builder response(Response response) {
            this.response = response;
            return this;
        }

        public Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public Builder numberOfAnswer(Optional<NumberOfAnswersPolicy> numberOfAnswers) {
            this.numberOfAnswers = numberOfAnswers;
            return this;
        }

        public MockSMTPBehavior build() {
            Preconditions.checkState((this.smtpCommand != null ? 1 : 0) != 0, (Object)"You need to specify an smtpCommand");
            Preconditions.checkState((this.response != null ? 1 : 0) != 0, (Object)"You need to specify a response");
            return new MockSMTPBehavior(this.smtpCommand, this.condition, this.response, this.numberOfAnswers.orElse(NumberOfAnswersPolicy.anytime()));
        }
    }
}

