/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mock.smtp.server.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import javax.mail.internet.AddressException;
import org.apache.james.core.MailAddress;

public class MailAddressDeserializer
extends JsonDeserializer<MailAddress> {
    public MailAddress deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        String value = jsonParser.getValueAsString();
        try {
            return new MailAddress(value);
        }
        catch (AddressException exception) {
            throw new JsonParseException(jsonParser, String.format("Something went wrong when trying to parse %s into a mail address", value), (Throwable)exception);
        }
    }
}

