/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mock.smtp.server;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import javax.mail.internet.AddressException;
import org.apache.commons.io.IOUtils;
import org.apache.james.core.MailAddress;
import org.apache.james.mock.smtp.server.ReceivedMailRepository;
import org.apache.james.mock.smtp.server.SMTPBehaviorRepository;
import org.apache.james.mock.smtp.server.model.Mail;
import org.apache.james.mock.smtp.server.model.MockSMTPBehavior;
import org.apache.james.mock.smtp.server.model.MockSMTPBehaviorInformation;
import org.apache.james.mock.smtp.server.model.Response;
import org.apache.james.mock.smtp.server.model.SMTPCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.RejectException;

public class MockMessageHandler
implements MessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockMessageHandler.class);
    private final Mail.Envelope.Builder envelopeBuilder;
    private final Mail.Builder mailBuilder;
    private final ReceivedMailRepository mailRepository;
    private final SMTPBehaviorRepository behaviorRepository;

    MockMessageHandler(ReceivedMailRepository mailRepository, SMTPBehaviorRepository behaviorRepository) {
        this.mailRepository = mailRepository;
        this.behaviorRepository = behaviorRepository;
        this.envelopeBuilder = new Mail.Envelope.Builder();
        this.mailBuilder = new Mail.Builder();
    }

    public void from(String from) throws RejectException {
        Optional<Behavior<Behavior>> fromBehavior = this.firstMatchedBehavior(SMTPCommand.MAIL_FROM, from);
        fromBehavior.orElseGet(() -> this.envelopeBuilder::from).behave(this.parse(from));
    }

    public void from(String from, Collection<Mail.Parameter> parameters) throws RejectException {
        Optional<Behavior<Behavior>> fromBehavior = this.firstMatchedBehavior(SMTPCommand.MAIL_FROM, from);
        fromBehavior.orElseGet(() -> mailAddress -> this.envelopeBuilder.from((MailAddress)mailAddress).mailParameters(parameters)).behave(this.parse(from));
    }

    public void recipient(String recipient) throws RejectException {
        Optional<Behavior<Behavior>> recipientBehavior = this.firstMatchedBehavior(SMTPCommand.RCPT_TO, recipient);
        recipientBehavior.orElseGet(() -> this.envelopeBuilder::addRecipientMailAddress).behave(this.parse(recipient));
    }

    public void recipient(String recipient, Collection<Mail.Parameter> parameters) throws RejectException {
        Optional<Behavior<Behavior>> recipientBehavior = this.firstMatchedBehavior(SMTPCommand.RCPT_TO, recipient);
        recipientBehavior.orElseGet(() -> address -> this.envelopeBuilder.addRecipient(Mail.Recipient.builder().parameters(parameters).address((MailAddress)address).build())).behave(this.parse(recipient));
    }

    public void data(InputStream data) throws RejectException {
        String dataString = this.readData(data);
        Optional<Behavior<Behavior>> dataBehavior = this.firstMatchedBehavior(SMTPCommand.DATA, dataString);
        dataBehavior.orElseGet(() -> this.mailBuilder::message).behave(dataString);
    }

    private <T> Optional<Behavior<T>> firstMatchedBehavior(SMTPCommand data, String dataLine) {
        return this.behaviorRepository.remainingBehaviors().map(MockSMTPBehaviorInformation::getBehavior).filter(behavior -> behavior.getCommand().equals((Object)data)).filter(behavior -> behavior.getCondition().matches(dataLine)).findFirst().map(behavior -> ComposedBehavior.startWith(new MockBehavior((MockSMTPBehavior)behavior)).andThen(any -> this.behaviorRepository.decreaseRemainingAnswers((MockSMTPBehavior)behavior)));
    }

    public void done() {
        Mail mail = this.mailBuilder.envelope(this.envelopeBuilder.build()).build();
        this.mailRepository.store(mail);
        LOGGER.info("Storing mail with envelope {}", (Object)mail.getEnvelope());
    }

    private String readData(InputStream data) {
        try {
            return IOUtils.toString((InputStream)data, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.error("Error reading data", (Throwable)e);
            throw new RejectException(Response.SMTPStatusCode.SYNTAX_ERROR_IN_PARAMETERS_OR_ARGUMENTS_501.getRawCode(), "invalid data supplied");
        }
    }

    private MailAddress parse(String mailAddress) {
        if (mailAddress.isEmpty()) {
            return MailAddress.nullSender();
        }
        try {
            return new MailAddress(mailAddress);
        }
        catch (AddressException e) {
            LOGGER.error("Error parsing mail address '{}'", (Object)mailAddress, (Object)e);
            throw new RejectException(Response.SMTPStatusCode.SYNTAX_ERROR_IN_PARAMETERS_OR_ARGUMENTS_501.getRawCode(), "invalid email address supplied");
        }
    }

    @FunctionalInterface
    private static interface Behavior<T> {
        public void behave(T var1) throws RejectException;
    }

    private static class MockBehavior<T>
    implements Behavior<T> {
        private final MockSMTPBehavior behavior;

        MockBehavior(MockSMTPBehavior behavior) {
            this.behavior = behavior;
        }

        @Override
        public void behave(T input) throws RejectException {
            Response response = this.behavior.getResponse();
            LOGGER.info("Applying behavior {}", (Object)this.behavior);
            throw new RejectException(response.getCode().getRawCode(), response.getMessage());
        }
    }

    private static class ComposedBehavior<T>
    implements Behavior<T> {
        private final Behavior<T> behavior1;
        private final Behavior<T> behavior2;

        private static <V> Builder<V> startWith(Behavior<V> behavior1) {
            return new Builder<V>(behavior1);
        }

        private ComposedBehavior(Behavior<T> behavior1, Behavior<T> behavior2) {
            this.behavior1 = behavior1;
            this.behavior2 = behavior2;
        }

        @Override
        public void behave(T input) throws RejectException {
            try {
                this.behavior1.behave(input);
            }
            finally {
                this.behavior2.behave(input);
            }
        }

        private static class Builder<U> {
            private final Behavior<U> behavior1;

            private Builder(Behavior<U> behavior1) {
                this.behavior1 = behavior1;
            }

            ComposedBehavior<U> andThen(Behavior<U> behavior2) {
                return new ComposedBehavior<U>(this.behavior1, behavior2);
            }
        }
    }
}

