/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mock.smtp.server;

import com.google.common.base.CharMatcher;
import java.io.IOException;
import java.util.Locale;
import org.apache.james.mock.smtp.server.MockMessageHandler;
import org.apache.james.mock.smtp.server.model.Mail;
import org.subethamail.smtp.DropConnectionException;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.server.BaseCommand;
import org.subethamail.smtp.server.Session;
import org.subethamail.smtp.util.EmailUtils;

public class ExtendedMailFromCommand
extends BaseCommand {
    public static final CharMatcher NUMBER_MATCHER = CharMatcher.inRange((char)'0', (char)'9');

    public ExtendedMailFromCommand() {
        super("MAIL", "Specifies the sender.", "FROM: <sender> [ <parameters> ]");
    }

    public void execute(String commandString, Session sess) throws IOException, DropConnectionException {
        if (sess.getHasMailFrom()) {
            sess.sendResponse("503 Sender already specified.");
        } else {
            if (commandString.trim().equals("MAIL FROM:")) {
                sess.sendResponse("501 Syntax: MAIL FROM: <address>");
                return;
            }
            String args = this.getArgPredicate(commandString);
            if (!args.toUpperCase(Locale.ENGLISH).startsWith("FROM:")) {
                sess.sendResponse("501 Syntax: MAIL FROM: <address>  Error in parameters: \"" + this.getArgPredicate(commandString) + "\"");
                return;
            }
            String emailAddress = EmailUtils.extractEmailAddress((String)args, (int)5);
            if (EmailUtils.isValidEmailAddress((String)emailAddress)) {
                String ssize;
                int size = 0;
                String largs = args.toLowerCase(Locale.ENGLISH);
                int sizec = largs.indexOf(" size=");
                if (sizec > -1 && (ssize = largs.substring(sizec + 6).trim()).length() > 0 && NUMBER_MATCHER.matchesAllOf((CharSequence)ssize)) {
                    size = Integer.parseInt(ssize);
                }
                if (size > sess.getServer().getMaxMessageSize()) {
                    sess.sendResponse("552 5.3.4 Message size exceeds fixed limit");
                    return;
                }
                try {
                    sess.startMailTransaction();
                    MockMessageHandler messageHandler = (MockMessageHandler)sess.getMessageHandler();
                    messageHandler.from(emailAddress, Mail.Parameter.fromArgLine(args));
                    sess.setDeclaredMessageSize(size);
                    sess.setHasMailFrom(true);
                    sess.sendResponse("250 Ok");
                }
                catch (DropConnectionException dropConnectionException) {
                    throw dropConnectionException;
                }
                catch (RejectException rejectException) {
                    sess.sendResponse(rejectException.getErrorResponse());
                }
            } else {
                sess.sendResponse("553 <" + emailAddress + "> Invalid email address.");
            }
        }
    }
}

