/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.james.core.MailAddress;
import org.apache.james.queue.api.Mails;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.webadmin.dto.MailQueueItemDTO;
import org.apache.mailet.Mail;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

class MailQueueItemDTOTest {
    MailQueueItemDTOTest() {
    }

    @Test
    void buildShouldThrowWhenNameIsNull() {
        Assertions.assertThatThrownBy(() -> MailQueueItemDTO.builder().build()).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void buildShouldThrowWhenNameIsEmpty() {
        Assertions.assertThatThrownBy(() -> MailQueueItemDTO.builder().name("").build()).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromShouldCreateTheRightObject() throws Exception {
        FakeMail mail = Mails.defaultMail().name("name").build();
        ZonedDateTime date = ZonedDateTime.parse("2018-01-02T11:22:02Z");
        ManageableMailQueue.DefaultMailQueueItemView mailQueueItemView = new ManageableMailQueue.DefaultMailQueueItemView((Mail)mail, date);
        MailQueueItemDTO mailQueueItemDTO = MailQueueItemDTO.from((ManageableMailQueue.MailQueueItemView)mailQueueItemView);
        List expectedRecipients = (List)mail.getRecipients().stream().map(MailAddress::asString).collect(ImmutableList.toImmutableList());
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(mailQueueItemDTO.getName()).isEqualTo(mail.getName());
            softly.assertThat(mailQueueItemDTO.getSender()).isEqualTo(mail.getMaybeSender().get().asString());
            softly.assertThat(mailQueueItemDTO.getRecipients()).isEqualTo((Object)expectedRecipients);
            softly.assertThat(mailQueueItemDTO.getNextDelivery()).contains((Object)date);
        });
    }
}

