/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import java.util.Optional;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.task.Hostname;
import org.apache.james.task.MemoryTaskManager;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.routes.MailQueueRoutes;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MailQueueRoutesUnitTest {
    MailQueueRoutes testee;

    MailQueueRoutesUnitTest() {
    }

    @BeforeEach
    void setup() {
        MemoryTaskManager taskManager = new MemoryTaskManager(new Hostname("foo"));
        MailQueueFactory mailQueueFactory = null;
        this.testee = new MailQueueRoutes(mailQueueFactory, new JsonTransformer(new JsonTransformerModule[0]), (TaskManager)taskManager);
    }

    @Test
    void isDelayedShouldReturnEmptyWhenNull() {
        Optional delayed = this.testee.isDelayed(null);
        Assertions.assertThat((Optional)delayed).isEmpty();
    }

    @Test
    void isDelayedShouldBeEqualsToTrueWhenTrue() {
        Optional delayed = this.testee.isDelayed("true");
        Assertions.assertThat((Optional)delayed).contains((Object)true);
    }

    @Test
    void isDelayedShouldBeEqualsToFalseWhenFalse() {
        Optional delayed = this.testee.isDelayed("false");
        Assertions.assertThat((Optional)delayed).contains((Object)false);
    }

    @Test
    void isDelayedShouldBeEqualsToFalseWhenOtherValue() {
        Optional delayed = this.testee.isDelayed("abc");
        Assertions.assertThat((Optional)delayed).contains((Object)false);
    }
}

