/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.james.json.DTOModule;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearMailQueueTask
implements Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClearMailQueueTask.class);
    public static final String TYPE = "clear-mail-queue";
    public static final Function<MailQueueFactory<ManageableMailQueue>, TaskDTOModule<ClearMailQueueTask, ClearMailQueueTaskDTO>> MODULE = mailQueueFactory -> (TaskDTOModule)DTOModule.forDomainObject(ClearMailQueueTask.class).convertToDTO(ClearMailQueueTaskDTO.class).toDomainObjectConverter(dto -> dto.fromDTO((MailQueueFactory<ManageableMailQueue>)mailQueueFactory)).toDTOConverter(ClearMailQueueTaskDTO::toDTO).typeName(TYPE).withFactory(TaskDTOModule::new);
    private final ManageableMailQueue queue;
    private final AdditionalInformation additionalInformation;

    public ClearMailQueueTask(ManageableMailQueue queue) {
        this.queue = queue;
        this.additionalInformation = new AdditionalInformation(queue.getName(), this::getRemainingSize);
    }

    public Task.Result run() {
        try {
            this.queue.clear();
        }
        catch (MailQueue.MailQueueException e) {
            LOGGER.error("Clear MailQueue got an exception", (Throwable)e);
            return Task.Result.PARTIAL;
        }
        return Task.Result.COMPLETED;
    }

    public String type() {
        return TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(this.additionalInformation);
    }

    private long getRemainingSize() {
        try {
            return this.queue.getSize();
        }
        catch (MailQueue.MailQueueException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ClearMailQueueTaskDTO
    implements TaskDTO {
        private final String type;
        private final String queue;

        public static ClearMailQueueTaskDTO toDTO(ClearMailQueueTask domainObject, String typeName) {
            return new ClearMailQueueTaskDTO(typeName, domainObject.queue.getName());
        }

        public ClearMailQueueTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="queue") String queue) {
            this.type = type;
            this.queue = queue;
        }

        public ClearMailQueueTask fromDTO(MailQueueFactory<ManageableMailQueue> mailQueueFactory) {
            return new ClearMailQueueTask((ManageableMailQueue)mailQueueFactory.getQueue(this.queue).orElseThrow(() -> new UnknownSerializedQueue(this.queue)));
        }

        public String getType() {
            return this.type;
        }

        public String getQueue() {
            return this.queue;
        }
    }

    public static class UnknownSerializedQueue
    extends RuntimeException {
        public UnknownSerializedQueue(String queueName) {
            super("Unable to retrieve '" + queueName + "' queue");
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final String mailQueueName;
        private final long initialCount;
        private final Supplier<Long> countSupplier;

        public AdditionalInformation(String mailQueueName, Supplier<Long> countSupplier) {
            this.mailQueueName = mailQueueName;
            this.countSupplier = countSupplier;
            this.initialCount = countSupplier.get();
        }

        public String getMailQueueName() {
            return this.mailQueueName;
        }

        public long getInitialCount() {
            return this.initialCount;
        }

        public long getRemainingCount() {
            return this.countSupplier.get();
        }
    }
}

