/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.github.steveash.guavate.Guavate;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.james.core.MailAddress;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.NoopMetricFactory;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.Mails;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.api.RawMailQueueItemDecoratorFactory;
import org.apache.james.queue.memory.MemoryMailQueueFactory;
import org.apache.james.task.MemoryTaskManager;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.MailQueueRoutes;
import org.apache.james.webadmin.routes.TasksRoutes;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.apache.mailet.Mail;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class MailQueueRoutesTest {
    static final String FIRST_QUEUE = "first one";
    static final String SECOND_QUEUE = "second one";
    static final String THIRD_QUEUE = "third one";
    static final String FOURTH_QUEUE = "fourth one";
    static final String SENDER_1_JAMES_ORG = "sender1@james.org";
    static final String SENDER_2_JAMES_ORG = "sender2@james.org";
    static final String RECIPIENT_JAMES_ORG = "recipient@james.org";
    static final String RECIPIENT_1_JAMES_ORG = "recipient1@james.org";
    static final String RECIPIENT_2_JAMES_ORG = "recipient2@james.org";
    static final String FAKE_MAIL_NAME_1 = "fake mail name 1";
    static final String FAKE_MAIL_NAME_2 = "fake mail name 2";
    static final String FAKE_MAIL_NAME_3 = "fake mail name 3";
    WebAdminServer webAdminServer;
    MemoryMailQueueFactory mailQueueFactory;

    WebAdminServer createServer(MemoryMailQueueFactory mailQueueFactory) throws Exception {
        MemoryTaskManager taskManager = new MemoryTaskManager();
        JsonTransformer jsonTransformer = new JsonTransformer(new JsonTransformerModule[0]);
        WebAdminServer server = WebAdminUtils.createWebAdminServer((MetricFactory)new NoopMetricFactory(), (Routes[])new Routes[]{new MailQueueRoutes((MailQueueFactory)mailQueueFactory, jsonTransformer, (TaskManager)taskManager), new TasksRoutes((TaskManager)taskManager, jsonTransformer)});
        server.configure(WebAdminServer.NO_CONFIGURATION);
        server.await();
        return server;
    }

    RequestSpecification buildRequestSpecification(WebAdminServer server) {
        return new RequestSpecBuilder().setContentType(ContentType.JSON).setAccept(ContentType.JSON).setBasePath("/mailQueues").setPort(server.getPort().getValue()).setConfig(RestAssuredConfig.newConfig().encoderConfig(EncoderConfig.encoderConfig().defaultContentCharset(StandardCharsets.UTF_8))).build();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.mailQueueFactory = new MemoryMailQueueFactory((MailQueueItemDecoratorFactory)new RawMailQueueItemDecoratorFactory());
        this.webAdminServer = this.createServer(this.mailQueueFactory);
        RestAssured.requestSpecification = this.buildRequestSpecification(this.webAdminServer);
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    @AfterEach
    public void tearDown() {
        this.webAdminServer.destroy();
    }

    @Nested
    class ClearMail {
        ClearMail() {
        }

        @Test
        public void clearMailQueueShouldReturnNotFoundWhenMailQueueDoesNotExist() throws Exception {
            MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
            ((ValidatableResponse)((Response)RestAssured.when().delete("second one/mails", new Object[0])).then()).statusCode(404);
        }

        @Test
        public void clearMailQueueShouldCompleteWhenNoQueryParameters() {
            MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
            String taskId = ((Response)RestAssured.with().delete("first one/mails", new Object[0])).jsonPath().getString("taskId");
            ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
        }

        @Test
        public void clearMailQueueShouldHaveDetailsWhenNoQueryParameters() throws Exception {
            MemoryMailQueueFactory.MemoryMailQueue queue = MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
            queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_1).build());
            queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_2).build());
            queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_3).build());
            String taskId = ((Response)RestAssured.with().delete("first one/mails", new Object[0])).jsonPath().getString("taskId");
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"clearMailQueue"), new Object[0])).body("additionalInformation.mailQueueName", Matchers.is((Object)MailQueueRoutesTest.FIRST_QUEUE), new Object[0])).body("additionalInformation.initialCount", Matchers.is((Object)3), new Object[0])).body("additionalInformation.remainingCount", Matchers.is((Object)0), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
        }

        @Test
        public void clearMailQueueShouldDeleteAllMailsInQueueWhenNoQueryParameters() throws Exception {
            MemoryMailQueueFactory.MemoryMailQueue queue = MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
            queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_1).build());
            queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_2).build());
            queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_3).build());
            String taskId = ((Response)RestAssured.with().delete("first one/mails", new Object[0])).jsonPath().getString("taskId");
            ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
            Assertions.assertThat((long)queue.getSize()).isEqualTo(0L);
        }
    }

    @Nested
    class DeleteMail {
        DeleteMail() {
        }

        @Nested
        class SideEffects {
            SideEffects() {
            }

            @Test
            public void deleteMailsShouldDeleteMailsWhenSenderIsGiven() throws Exception {
                MemoryMailQueueFactory.MemoryMailQueue queue = MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_1).sender(MailQueueRoutesTest.SENDER_1_JAMES_ORG).build());
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_2).sender(MailQueueRoutesTest.SENDER_2_JAMES_ORG).build());
                String taskId = ((Response)RestAssured.with().param("sender", new Object[]{MailQueueRoutesTest.SENDER_1_JAMES_ORG}).delete("first one/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
                ((ObjectAssert)((IterableAssert)Assertions.assertThat((Iterator)queue.browse()).hasSize(1)).first()).satisfies(mailView -> {
                    AbstractCharSequenceAssert cfr_ignored_0 = (AbstractCharSequenceAssert)Assertions.assertThat((String)mailView.getMail().getName()).isEqualTo((Object)MailQueueRoutesTest.FAKE_MAIL_NAME_2);
                });
            }

            @Test
            public void deleteMailsShouldDeleteMailsWhenNameIsGiven() throws Exception {
                MemoryMailQueueFactory.MemoryMailQueue queue = MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_1).build());
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_2).build());
                String taskId = ((Response)RestAssured.with().param("name", new Object[]{MailQueueRoutesTest.FAKE_MAIL_NAME_1}).delete("first one/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
                ((ObjectAssert)((IterableAssert)Assertions.assertThat((Iterator)queue.browse()).hasSize(1)).first()).satisfies(mailView -> {
                    AbstractCharSequenceAssert cfr_ignored_0 = (AbstractCharSequenceAssert)Assertions.assertThat((String)mailView.getMail().getName()).isEqualTo((Object)MailQueueRoutesTest.FAKE_MAIL_NAME_2);
                });
            }

            @Test
            public void deleteMailsShouldDeleteMailsWhenRecipientIsGiven() throws Exception {
                MemoryMailQueueFactory.MemoryMailQueue queue = MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_1).recipient(MailQueueRoutesTest.RECIPIENT_JAMES_ORG).build());
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_2).recipient(MailQueueRoutesTest.RECIPIENT_1_JAMES_ORG).build());
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_3).recipient(MailQueueRoutesTest.RECIPIENT_2_JAMES_ORG).build());
                String taskId = ((Response)RestAssured.with().param("recipient", new Object[]{MailQueueRoutesTest.RECIPIENT_JAMES_ORG}).delete("first one/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
                ((IterableAssert)Assertions.assertThat((Iterator)queue.browse()).hasSize(2)).extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getName).contains((Object[])new String[]{MailQueueRoutesTest.FAKE_MAIL_NAME_2, MailQueueRoutesTest.FAKE_MAIL_NAME_3});
            }

            @Test
            public void deleteMailsShouldDeleteMailsWhenTheyAreMatching() throws Exception {
                MemoryMailQueueFactory.MemoryMailQueue queue = MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                String recipient = MailQueueRoutesTest.RECIPIENT_JAMES_ORG;
                queue.enQueue((Mail)Mails.defaultMail().recipient(recipient).build());
                queue.enQueue((Mail)Mails.defaultMail().build());
                queue.enQueue((Mail)Mails.defaultMail().build());
                String taskId = ((Response)RestAssured.with().param("recipient", new Object[]{recipient}).delete("first one/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
                MailAddress deletedRecipientMailAddress = new MailAddress(recipient);
                ((IterableAssert)Assertions.assertThat((Iterator)queue.browse()).hasSize(2)).allSatisfy(item -> Assertions.assertThat((Iterable)item.getMail().getRecipients()).doesNotContain((Object[])new MailAddress[]{deletedRecipientMailAddress}));
            }
        }

        @Nested
        class HttpBodies {
            HttpBodies() {
            }

            @Test
            public void deleteMailsTasksShouldCompleteWhenSenderIsValid() throws Exception {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                String taskId = ((Response)RestAssured.with().param("sender", new Object[]{MailQueueRoutesTest.SENDER_1_JAMES_ORG}).delete("first one/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
            }

            @Test
            public void deleteMailsShouldCompleteWhenNameIsValid() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                String taskId = ((Response)RestAssured.with().param("name", new Object[]{"mailName"}).delete("first one/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
            }

            @Test
            public void deleteMailsShouldCompleteWhenRecipientIsValid() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                String taskId = ((Response)RestAssured.with().param("recipient", new Object[]{MailQueueRoutesTest.RECIPIENT_JAMES_ORG}).delete("first one/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
            }

            @Test
            public void deleteMailsTasksShouldHaveDetailsWhenSenderIsGiven() throws Exception {
                MemoryMailQueueFactory.MemoryMailQueue queue = MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_1).sender(MailQueueRoutesTest.SENDER_1_JAMES_ORG).build());
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_2).sender(MailQueueRoutesTest.SENDER_2_JAMES_ORG).build());
                String taskId = ((Response)RestAssured.with().param("sender", new Object[]{MailQueueRoutesTest.SENDER_1_JAMES_ORG}).delete("first one/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"deleteMailsFromMailQueue"), new Object[0])).body("additionalInformation.mailQueueName", Matchers.is((Object)MailQueueRoutesTest.FIRST_QUEUE), new Object[0])).body("additionalInformation.initialCount", Matchers.is((Object)2), new Object[0])).body("additionalInformation.remainingCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.sender", Matchers.is((Object)MailQueueRoutesTest.SENDER_1_JAMES_ORG), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
            }

            @Test
            public void deleteMailsTasksShouldHaveDetailsWhenNameIsGiven() throws Exception {
                MemoryMailQueueFactory.MemoryMailQueue queue = MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_1).build());
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_2).build());
                String taskId = ((Response)RestAssured.with().param("name", new Object[]{MailQueueRoutesTest.FAKE_MAIL_NAME_1}).delete("first one/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"deleteMailsFromMailQueue"), new Object[0])).body("additionalInformation.mailQueueName", Matchers.is((Object)MailQueueRoutesTest.FIRST_QUEUE), new Object[0])).body("additionalInformation.initialCount", Matchers.is((Object)2), new Object[0])).body("additionalInformation.remainingCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.name", Matchers.is((Object)MailQueueRoutesTest.FAKE_MAIL_NAME_1), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
            }

            @Test
            public void deleteMailsTasksShouldHaveDetailsWhenRecipientIsGiven() throws Exception {
                MemoryMailQueueFactory.MemoryMailQueue queue = MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_1).recipient(MailQueueRoutesTest.RECIPIENT_JAMES_ORG).build());
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_2).recipient(MailQueueRoutesTest.RECIPIENT_JAMES_ORG).build());
                queue.enQueue((Mail)FakeMail.builder().name(MailQueueRoutesTest.FAKE_MAIL_NAME_2).recipient(MailQueueRoutesTest.RECIPIENT_1_JAMES_ORG).build());
                String taskId = ((Response)RestAssured.with().param("recipient", new Object[]{MailQueueRoutesTest.RECIPIENT_JAMES_ORG}).delete("first one/mails", new Object[0])).jsonPath().getString("taskId");
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"deleteMailsFromMailQueue"), new Object[0])).body("additionalInformation.mailQueueName", Matchers.is((Object)MailQueueRoutesTest.FIRST_QUEUE), new Object[0])).body("additionalInformation.initialCount", Matchers.is((Object)3), new Object[0])).body("additionalInformation.remainingCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.recipient", Matchers.is((Object)MailQueueRoutesTest.RECIPIENT_JAMES_ORG), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
            }
        }

        @Nested
        class DataValidation {
            DataValidation() {
            }

            @Test
            public void deleteMailsShouldReturnNotFoundWhenMailQueueDoesntExist() {
                ((ValidatableResponse)((Response)RestAssured.when().delete("first one/mails", new Object[0])).then()).statusCode(404);
            }

            @Test
            public void deleteMailsShouldReturnBadRequestWhenSenderIsInvalid() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().param("sender", new Object[]{"123"}).when().delete("first one/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            public void deleteMailsShouldReturnBadRequestWhenRecipientIsInvalid() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().param("recipient", new Object[]{"123"}).when().delete("first one/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            public void deleteMailsShouldReturnBadRequestWhenAllParametersAreGiven() throws Exception {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().param("sender", new Object[]{"sender@james.org"}).param("name", new Object[]{"mailName"}).param("recipient", new Object[]{MailQueueRoutesTest.RECIPIENT_JAMES_ORG}).when().delete("first one/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            public void deleteMailsShouldReturnBadRequestWhenTwoParametersAreGiven() throws Exception {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().param("sender", new Object[]{"sender@james.org"}).param("name", new Object[]{"mailName"}).when().delete("first one/mails", new Object[0])).then()).statusCode(400);
            }
        }
    }

    @Nested
    class ForceDelayedMailsDelivery {
        ForceDelayedMailsDelivery() {
        }

        @Nested
        class SideEffects {
            SideEffects() {
            }

            @Test
            public void forcingDelayedMailsDeliveryShouldActuallyChangePropertyOnMails() throws Exception {
                MemoryMailQueueFactory.MemoryMailQueue queue = MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                FakeMail mail = Mails.defaultMail().build();
                queue.enQueue((Mail)mail, 10L, TimeUnit.MINUTES);
                queue.enQueue((Mail)mail, 10L, TimeUnit.MINUTES);
                queue.enQueue((Mail)mail);
                RestAssured.with().queryParam("delayed", new Object[]{"true"}).body("{\"delayed\": \"false\"}").when().patch("first one/mails", new Object[0]);
                ((AbstractListAssert)Assertions.assertThat((Iterator)queue.browse()).extracting(ManageableMailQueue.MailQueueItemView::getNextDelivery).hasSize(3)).allSatisfy(delivery -> {
                    Assertions.assertThat((Optional)delivery).isNotEmpty();
                    Assertions.assertThat((ZonedDateTime)((ZonedDateTime)delivery.get())).isBefore(ZonedDateTime.now());
                });
            }
        }

        @Nested
        class DataValidation {
            DataValidation() {
            }

            @Test
            public void forcingDelayedMailsDeliveryShouldReturnNoContent() throws Exception {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"true"}).body("{\"delayed\": \"false\"}").when().patch("first one/mails", new Object[0])).then()).statusCode(204);
            }

            @Test
            public void forcingDelayedMailsDeliveryForUnknownQueueShouldReturnNotFound() throws Exception {
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"true"}).body("{\"delayed\": \"false\"}").when().patch("unknown queue/mails", new Object[0])).then()).statusCode(404);
            }

            @Test
            public void forcingDelayedMailsDeliveryRequiresDelayedParameter() throws Exception {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().body("{\"delayed\": \"false\"}").when().patch("first one/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            public void forcingDelayedMailsDeliveryShouldRejectFalseDelayedParam() throws Exception {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"false"}).body("{\"delayed\": \"false\"}").when().patch("first one/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            public void forcingDelayedMailsDeliveryShouldRejectNonBooleanDelayedParam() throws Exception {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"wrong"}).body("{\"delayed\": \"false\"}").when().patch("first one/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            public void forcingDelayedMailsDeliveryShouldRejectRequestWithoutBody() throws Exception {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"true"}).when().patch("first one/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            public void forcingDelayedMailsDeliveryShouldRejectRequestWithoutDelayedParameter() throws Exception {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"true"}).body("{\"xx\": \"false\"}").when().patch("first one/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            public void forcingDelayedMailsDeliveryShouldAcceptRequestWithUnknownFields() throws Exception {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"true"}).body("{\"xx\": \"false\",\"delayed\": \"false\"}").when().patch("first one/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            public void forcingDelayedMailsDeliveryShouldRejectMalformedJsonPayload() throws Exception {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"true"}).body("{\"xx\":").when().patch("first one/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            public void forcingDelayedMailsDeliveryShouldRejectTrueDelayedAttribute() throws Exception {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"false"}).body("{\"delayed\": \"true\"}").when().patch("first one/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            public void forcingDelayedMailsDeliveryShouldRejectStringDelayedAttribute() throws Exception {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("delayed", new Object[]{"false"}).body("{\"delayed\": \"string\"}").when().patch("first one/mails", new Object[0])).then()).statusCode(400);
            }
        }
    }

    @Nested
    class GetMailQueue {
        GetMailQueue() {
        }

        @Test
        public void getMailQueueShouldReturnTheMailQueueDataWhenMailQueueExists() throws Exception {
            MemoryMailQueueFactory.MemoryMailQueue queue = MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
            queue.enQueue((Mail)Mails.defaultMail().build());
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(MailQueueRoutesTest.FIRST_QUEUE, new Object[0])).then()).statusCode(200)).body("name", Matchers.equalTo((Object)MailQueueRoutesTest.FIRST_QUEUE), new Object[0])).body("size", Matchers.equalTo((Object)1), new Object[0]);
        }

        @Test
        public void getMailQueueShouldReturnNotFoundWhenMailQueueDoesntExist() {
            ((ValidatableResponse)((Response)RestAssured.when().get(MailQueueRoutesTest.FIRST_QUEUE, new Object[0])).then()).statusCode(404);
        }
    }

    @Nested
    class ListMail {
        ListMail() {
        }

        @Nested
        class HttpBodies {
            HttpBodies() {
            }

            @Test
            public void listAllMailQueuesShouldReturnEmptyWhenNone() {
                List actual = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getList(".");
                Assertions.assertThat((List)actual).isEmpty();
            }

            @Test
            public void listAllMailQueuesShouldReturnSingleElementListWhenOnlyOneMailQueue() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                List actual = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getList(".");
                Assertions.assertThat((List)actual).containsOnly((Object[])new String[]{MailQueueRoutesTest.FIRST_QUEUE});
            }

            @Test
            public void listAllMailQueuesShouldReturnListWhenSeveralMailQueues() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.SECOND_QUEUE);
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.THIRD_QUEUE);
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FOURTH_QUEUE);
                List actual = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getList(".");
                Assertions.assertThat((List)actual).containsOnly((Object[])new String[]{MailQueueRoutesTest.FIRST_QUEUE, MailQueueRoutesTest.SECOND_QUEUE, MailQueueRoutesTest.THIRD_QUEUE, MailQueueRoutesTest.FOURTH_QUEUE});
            }

            @Test
            public void listMailsShouldReturnEmptyListWhenNoMails() {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("first one/mails", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.empty(), new Object[0]);
            }

            @Test
            public void listMailsShouldReturnMailsWhenSome() throws Exception {
                MemoryMailQueueFactory.MemoryMailQueue queue = MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                queue.enQueue((Mail)Mails.defaultMail().build());
                queue.enQueue((Mail)Mails.defaultMail().build());
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("first one/mails", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.hasSize((int)2), new Object[0]);
            }

            @Test
            public void listMailsShouldReturnMailDetailsWhenSome() throws Exception {
                MemoryMailQueueFactory.MemoryMailQueue queue = MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                FakeMail mail = Mails.defaultMail().build();
                queue.enQueue((Mail)mail);
                String firstMail = "[0]";
                List expectedRecipients = (List)mail.getRecipients().stream().map(MailAddress::asString).collect(Guavate.toImmutableList());
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("first one/mails", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.hasSize((int)1), new Object[0])).body(firstMail + ".name", Matchers.equalTo((Object)mail.getName()), new Object[0])).body(firstMail + ".sender", Matchers.equalTo((Object)MailAddressFixture.SENDER.asString()), new Object[0])).body(firstMail + ".recipients", Matchers.equalTo((Object)expectedRecipients), new Object[0]);
            }

            @Test
            public void listMailsShouldReturnEmptyWhenNoDelayedMailsAndAskFor() throws Exception {
                MemoryMailQueueFactory.MemoryMailQueue queue = MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                FakeMail mail = Mails.defaultMail().build();
                queue.enQueue((Mail)mail);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("delayed", new Object[]{"true"}).when().get("first one/mails", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.empty(), new Object[0]);
            }

            @Test
            public void listMailsShouldReturnCurrentMailsWhenMailsAndAskForNotDelayed() throws Exception {
                MemoryMailQueueFactory.MemoryMailQueue queue = MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                FakeMail mail = Mails.defaultMail().build();
                queue.enQueue((Mail)mail);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("delayed", new Object[]{"false"}).when().get("first one/mails", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.hasSize((int)1), new Object[0]);
            }

            @Test
            public void listMailsShouldReturnDelayedMailsWhenAskFor() throws Exception {
                MemoryMailQueueFactory.MemoryMailQueue queue = MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                FakeMail mail = Mails.defaultMail().build();
                queue.enQueue((Mail)mail, 10L, TimeUnit.MINUTES);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("delayed", new Object[]{"true"}).when().get("first one/mails", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.hasSize((int)1), new Object[0]);
            }

            @Test
            public void listMailsShouldReturnOneMailWhenMailsAndAskForALimitOfOne() throws Exception {
                MemoryMailQueueFactory.MemoryMailQueue queue = MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                FakeMail mail = Mails.defaultMail().build();
                queue.enQueue((Mail)mail);
                queue.enQueue((Mail)mail);
                queue.enQueue((Mail)mail);
                ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().param("limit", new Object[]{"1"}).when().get("first one/mails", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.hasSize((int)1), new Object[0]);
            }
        }

        @Nested
        class DataValidation {
            DataValidation() {
            }

            @Test
            public void listMailsShouldReturnBadRequestWhenLimitIsLessThanZero() throws Exception {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().param("limit", new Object[]{"-1"}).when().get("first one/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            public void listMailsShouldReturnBadRequestWhenLimitEqualsToZero() throws Exception {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().param("limit", new Object[]{"0"}).when().get("first one/mails", new Object[0])).then()).statusCode(400);
            }

            @Test
            public void listMailsShouldReturnBadRequestWhenLimitIsInvalid() throws Exception {
                MailQueueRoutesTest.this.mailQueueFactory.createQueue(MailQueueRoutesTest.FIRST_QUEUE);
                ((ValidatableResponse)((Response)RestAssured.given().param("limit", new Object[]{"abc"}).when().get("first one/mails", new Object[0])).then()).statusCode(400);
            }
        }
    }
}

