/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearMailQueueTask
implements Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClearMailQueueTask.class);
    public static final String TYPE = "clearMailQueue";
    private final ManageableMailQueue queue;
    private final AdditionalInformation additionalInformation;

    public ClearMailQueueTask(ManageableMailQueue queue) {
        this.queue = queue;
        this.additionalInformation = new AdditionalInformation(queue.getName(), this::getRemainingSize);
    }

    public Task.Result run() {
        try {
            this.queue.clear();
        }
        catch (MailQueue.MailQueueException e) {
            LOGGER.error("Clear MailQueue got an exception", (Throwable)e);
            return Task.Result.PARTIAL;
        }
        return Task.Result.COMPLETED;
    }

    public String type() {
        return TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(this.additionalInformation);
    }

    private long getRemainingSize() {
        try {
            return this.queue.getSize();
        }
        catch (MailQueue.MailQueueException e) {
            throw new RuntimeException(e);
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final String mailQueueName;
        private final long initialCount;
        private final Supplier<Long> countSupplier;

        public AdditionalInformation(String mailQueueName, Supplier<Long> countSupplier) {
            this.mailQueueName = mailQueueName;
            this.countSupplier = countSupplier;
            this.initialCount = countSupplier.get();
        }

        public String getMailQueueName() {
            return this.mailQueueName;
        }

        public long getInitialCount() {
            return this.initialCount;
        }

        public long getRemainingCount() {
            return this.countSupplier.get();
        }
    }
}

