/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.github.steveash.guavate.Guavate;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.james.core.MailAddress;
import org.apache.james.queue.api.Mails;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.webadmin.dto.MailQueueItemDTO;
import org.apache.mailet.Mail;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.JUnitSoftAssertions;
import org.junit.Rule;
import org.junit.Test;

public class MailQueueItemDTOTest {
    @Rule
    public final JUnitSoftAssertions softly = new JUnitSoftAssertions();

    @Test
    public void buildShouldThrowWhenNameIsNull() {
        Assertions.assertThatThrownBy(() -> MailQueueItemDTO.builder().build()).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void buildShouldThrowWhenNameIsEmpty() {
        Assertions.assertThatThrownBy(() -> MailQueueItemDTO.builder().name("").build()).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void fromShouldCreateTheRightObject() throws Exception {
        FakeMail mail = Mails.defaultMail().build();
        ZonedDateTime date = ZonedDateTime.parse("2018-01-02T11:22:02Z");
        ManageableMailQueue.MailQueueItemView mailQueueItemView = new ManageableMailQueue.MailQueueItemView((Mail)mail, date);
        MailQueueItemDTO mailQueueItemDTO = MailQueueItemDTO.from((ManageableMailQueue.MailQueueItemView)mailQueueItemView);
        List expectedRecipients = (List)mail.getRecipients().stream().map(MailAddress::asString).collect(Guavate.toImmutableList());
        this.softly.assertThat(mailQueueItemDTO.getName()).isEqualTo((Object)mail.getName());
        this.softly.assertThat(mailQueueItemDTO.getSender()).isEqualTo((Object)mail.getSender().asString());
        this.softly.assertThat(mailQueueItemDTO.getRecipients()).isEqualTo((Object)expectedRecipients);
        this.softly.assertThat(mailQueueItemDTO.getNextDelivery()).contains((Object)date);
    }
}

